/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.kdtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.kdtree.KdNode;
import com.vividsolutions.jts.index.kdtree.KdNodeVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KdTree {
    private long numberOfNodes;
    private KdNode root = null;
    private double tolerance;

    public KdTree() {
        this(0.0);
    }

    public KdTree(double d) {
        this.tolerance = d;
    }

    private KdNode findBestMatchNode(Coordinate object) {
        object = new BestMatchVisitor((Coordinate)object, this.tolerance);
        this.query(((BestMatchVisitor)object).queryEnvelope(), (KdNodeVisitor)object);
        return ((BestMatchVisitor)object).getNode();
    }

    private KdNode insertExact(Coordinate object, Object object2) {
        KdNode kdNode;
        KdNode kdNode2 = kdNode = this.root;
        boolean bl = true;
        boolean bl2 = true;
        while (true) {
            block9: {
                block10: {
                    boolean bl3;
                    block8: {
                        if (kdNode == null) {
                            ++this.numberOfNodes;
                            object = new KdNode((Coordinate)object, object2);
                            if (bl) {
                                kdNode2.setLeft((KdNode)object);
                            } else {
                                kdNode2.setRight((KdNode)object);
                            }
                            return object;
                        }
                        bl3 = false;
                        if (kdNode != null && (bl = ((Coordinate)object).distance(kdNode.getCoordinate()) <= this.tolerance)) {
                            kdNode.increment();
                            return kdNode;
                        }
                        if (!bl2) break block8;
                        bl = bl3;
                        if (!(((Coordinate)object).x < kdNode.getX())) break block9;
                        break block10;
                    }
                    bl = bl3;
                    if (!(((Coordinate)object).y < kdNode.getY())) break block9;
                }
                bl = true;
            }
            KdNode kdNode3 = bl ? kdNode.getLeft() : kdNode.getRight();
            bl2 ^= true;
            kdNode2 = kdNode;
            kdNode = kdNode3;
        }
    }

    private void queryNode(KdNode kdNode, Envelope envelope, boolean bl, KdNodeVisitor kdNodeVisitor) {
        double d;
        double d2;
        double d3;
        if (kdNode == null) {
            return;
        }
        if (bl) {
            d3 = envelope.getMinX();
            d2 = envelope.getMaxX();
            d = kdNode.getX();
        } else {
            d3 = envelope.getMinY();
            d2 = envelope.getMaxY();
            d = kdNode.getY();
        }
        boolean bl2 = false;
        boolean bl3 = d3 < d;
        if (d <= d2) {
            bl2 = true;
        }
        if (bl3) {
            this.queryNode(kdNode.getLeft(), envelope, bl ^ true, kdNodeVisitor);
        }
        if (envelope.contains(kdNode.getCoordinate())) {
            kdNodeVisitor.visit(kdNode);
        }
        if (bl2) {
            this.queryNode(kdNode.getRight(), envelope, bl ^ true, kdNodeVisitor);
        }
    }

    public static Coordinate[] toCoordinates(Collection collection) {
        return KdTree.toCoordinates(collection, false);
    }

    public static Coordinate[] toCoordinates(Collection object, boolean bl) {
        CoordinateList coordinateList = new CoordinateList();
        object = object.iterator();
        block0: while (object.hasNext()) {
            KdNode kdNode = (KdNode)object.next();
            int n = bl ? kdNode.getCount() : 1;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                coordinateList.add(kdNode.getCoordinate(), true);
                ++n2;
            }
            break;
        }
        return coordinateList.toCoordinateArray();
    }

    public KdNode insert(Coordinate coordinate) {
        return this.insert(coordinate, null);
    }

    public KdNode insert(Coordinate object, Object object2) {
        KdNode kdNode;
        if (this.root == null) {
            this.root = object = new KdNode((Coordinate)object, object2);
            return object;
        }
        if (this.tolerance > 0.0 && (kdNode = this.findBestMatchNode((Coordinate)object)) != null) {
            kdNode.increment();
            return kdNode;
        }
        return this.insertExact((Coordinate)object, object2);
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public List query(Envelope envelope) {
        ArrayList arrayList = new ArrayList();
        this.query(envelope, arrayList);
        return arrayList;
    }

    public void query(Envelope envelope, KdNodeVisitor kdNodeVisitor) {
        this.queryNode(this.root, envelope, true, kdNodeVisitor);
    }

    public void query(Envelope envelope, final List list) {
        this.queryNode(this.root, envelope, true, new KdNodeVisitor(){

            @Override
            public void visit(KdNode kdNode) {
                list.add(kdNode);
            }
        });
    }

    private static class BestMatchVisitor
    implements KdNodeVisitor {
        private double matchDist = 0.0;
        private KdNode matchNode = null;
        private Coordinate p;
        private double tolerance;

        public BestMatchVisitor(Coordinate coordinate, double d) {
            this.p = coordinate;
            this.tolerance = d;
        }

        public KdNode getNode() {
            return this.matchNode;
        }

        public Envelope queryEnvelope() {
            Envelope envelope = new Envelope(this.p);
            envelope.expandBy(this.tolerance);
            return envelope;
        }

        @Override
        public void visit(KdNode kdNode) {
            boolean bl;
            double d;
            block6: {
                block5: {
                    d = this.p.distance(kdNode.getCoordinate());
                    double d2 = this.tolerance;
                    boolean bl2 = false;
                    bl = d <= d2;
                    if (!bl) {
                        return;
                    }
                    KdNode kdNode2 = this.matchNode;
                    if (kdNode2 == null || d < (d2 = this.matchDist)) break block5;
                    bl = bl2;
                    if (kdNode2 == null) break block6;
                    bl = bl2;
                    if (d != d2) break block6;
                    bl = bl2;
                    if (kdNode.getCoordinate().compareTo(this.matchNode.getCoordinate()) >= 1) break block6;
                }
                bl = true;
            }
            if (bl) {
                this.matchNode = kdNode;
                this.matchDist = d;
            }
        }
    }
}

