/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.quadtree;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.ArrayListVisitor;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.quadtree.Root;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Quadtree
implements SpatialIndex,
Serializable {
    private static final long serialVersionUID = -7461163625812743604L;
    private double minExtent = 1.0;
    private Root root = new Root();

    private void collectStats(Envelope envelope) {
        double d = envelope.getWidth();
        if (d < this.minExtent && d > 0.0) {
            this.minExtent = d;
        }
        if ((d = envelope.getHeight()) < this.minExtent && d > 0.0) {
            this.minExtent = d;
        }
    }

    public static Envelope ensureExtent(Envelope envelope, double d) {
        double d2 = envelope.getMinX();
        double d3 = envelope.getMaxX();
        double d4 = envelope.getMinY();
        double d5 = envelope.getMaxY();
        double d6 = d2 == d3 ? 0 : (d2 > d3 ? 1 : -1);
        if (d6 != false && d4 != d5) {
            return envelope;
        }
        double d7 = d2;
        if (d6 == false) {
            d3 = d / 2.0;
            d7 = d2 - d3;
            d3 += d7;
        }
        double d8 = d4;
        d2 = d5;
        if (d4 == d5) {
            d8 = d4 - (d /= 2.0);
            d2 = d8 + d;
        }
        return new Envelope(d7, d3, d8, d2);
    }

    public int depth() {
        Root root = this.root;
        if (root != null) {
            return root.depth();
        }
        return 0;
    }

    @Override
    public void insert(Envelope envelope, Object object) {
        this.collectStats(envelope);
        envelope = Quadtree.ensureExtent(envelope, this.minExtent);
        this.root.insert(envelope, object);
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    @Override
    public List query(Envelope envelope) {
        ArrayListVisitor arrayListVisitor = new ArrayListVisitor();
        this.query(envelope, arrayListVisitor);
        return arrayListVisitor.getItems();
    }

    @Override
    public void query(Envelope envelope, ItemVisitor itemVisitor) {
        this.root.visit(envelope, itemVisitor);
    }

    public List queryAll() {
        ArrayList arrayList = new ArrayList();
        this.root.addAllItems(arrayList);
        return arrayList;
    }

    @Override
    public boolean remove(Envelope envelope, Object object) {
        envelope = Quadtree.ensureExtent(envelope, this.minExtent);
        return this.root.remove(envelope, object);
    }

    public int size() {
        Root root = this.root;
        if (root != null) {
            return root.size();
        }
        return 0;
    }
}

