/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.strtree;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.strtree.AbstractNode;
import com.vividsolutions.jts.index.strtree.Boundable;
import com.vividsolutions.jts.index.strtree.ItemBoundable;
import com.vividsolutions.jts.index.strtree.ItemDistance;
import com.vividsolutions.jts.util.PriorityQueue;
import java.util.Iterator;

class BoundablePair
implements Comparable {
    private Boundable boundable1;
    private Boundable boundable2;
    private double distance;
    private ItemDistance itemDistance;

    public BoundablePair(Boundable boundable, Boundable boundable2, ItemDistance itemDistance) {
        this.boundable1 = boundable;
        this.boundable2 = boundable2;
        this.itemDistance = itemDistance;
        this.distance = this.distance();
    }

    private static double area(Boundable boundable) {
        return ((Envelope)boundable.getBounds()).getArea();
    }

    private double distance() {
        if (this.isLeaves()) {
            return this.itemDistance.distance((ItemBoundable)this.boundable1, (ItemBoundable)this.boundable2);
        }
        return ((Envelope)this.boundable1.getBounds()).distance((Envelope)this.boundable2.getBounds());
    }

    private void expand(Boundable object, Boundable boundable, PriorityQueue priorityQueue, double d) {
        Iterator iterator2 = ((AbstractNode)object).getChildBoundables().iterator();
        while (iterator2.hasNext()) {
            object = new BoundablePair((Boundable)iterator2.next(), boundable, this.itemDistance);
            if (!(((BoundablePair)object).getDistance() < d)) continue;
            priorityQueue.add((Comparable)object);
        }
        return;
    }

    public static boolean isComposite(Object object) {
        return object instanceof AbstractNode;
    }

    public int compareTo(Object object) {
        object = (BoundablePair)object;
        double d = this.distance;
        double d2 = ((BoundablePair)object).distance;
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        return 0;
    }

    public void expandToQueue(PriorityQueue priorityQueue, double d) {
        boolean bl = BoundablePair.isComposite(this.boundable1);
        boolean bl2 = BoundablePair.isComposite(this.boundable2);
        if (bl && bl2) {
            if (BoundablePair.area(this.boundable1) > BoundablePair.area(this.boundable2)) {
                this.expand(this.boundable1, this.boundable2, priorityQueue, d);
                return;
            }
            this.expand(this.boundable2, this.boundable1, priorityQueue, d);
            return;
        }
        if (bl) {
            this.expand(this.boundable1, this.boundable2, priorityQueue, d);
            return;
        }
        if (bl2) {
            this.expand(this.boundable2, this.boundable1, priorityQueue, d);
            return;
        }
        throw new IllegalArgumentException("neither boundable is composite");
    }

    public Boundable getBoundable(int n) {
        if (n == 0) {
            return this.boundable1;
        }
        return this.boundable2;
    }

    public double getDistance() {
        return this.distance;
    }

    public boolean isLeaves() {
        boolean bl = !BoundablePair.isComposite(this.boundable1) && !BoundablePair.isComposite(this.boundable2);
        return bl;
    }
}

