/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io;

import com.vividsolutions.jts.io.ByteOrderValues;
import com.vividsolutions.jts.io.InStream;
import java.io.IOException;

public class ByteOrderDataInStream {
    private byte[] buf1 = new byte[1];
    private byte[] buf4 = new byte[4];
    private byte[] buf8 = new byte[8];
    private int byteOrder = 1;
    private InStream stream;

    public ByteOrderDataInStream() {
        this.stream = null;
    }

    public ByteOrderDataInStream(InStream inStream) {
        this.stream = inStream;
    }

    public byte readByte() throws IOException {
        this.stream.read(this.buf1);
        return this.buf1[0];
    }

    public double readDouble() throws IOException {
        this.stream.read(this.buf8);
        return ByteOrderValues.getDouble(this.buf8, this.byteOrder);
    }

    public int readInt() throws IOException {
        this.stream.read(this.buf4);
        return ByteOrderValues.getInt(this.buf4, this.byteOrder);
    }

    public long readLong() throws IOException {
        this.stream.read(this.buf8);
        return ByteOrderValues.getLong(this.buf8, this.byteOrder);
    }

    public void setInStream(InStream inStream) {
        this.stream = inStream;
    }

    public void setOrder(int n) {
        this.byteOrder = n;
    }
}

