/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.CoordinateSequences;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ByteArrayInStream;
import com.vividsolutions.jts.io.ByteOrderDataInStream;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;

public class WKBReader {
    private static final String INVALID_GEOM_TYPE_MSG = "Invalid geometry type encountered in ";
    private int SRID = 0;
    private CoordinateSequenceFactory csFactory;
    private ByteOrderDataInStream dis = new ByteOrderDataInStream();
    private GeometryFactory factory;
    private boolean hasSRID = false;
    private int inputDimension = 2;
    private boolean isStrict = false;
    private double[] ordValues;
    private PrecisionModel precisionModel;

    public WKBReader() {
        this(new GeometryFactory());
    }

    public WKBReader(GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
        this.precisionModel = geometryFactory.getPrecisionModel();
        this.csFactory = this.factory.getCoordinateSequenceFactory();
    }

    public static byte[] hexToBytes(String string2) {
        byte[] byArray = new byte[string2.length() / 2];
        int n = 0;
        while (true) {
            if (n >= string2.length() / 2) {
                return byArray;
            }
            int n2 = n * 2;
            int n3 = n2 + 1;
            if (n3 > string2.length()) break;
            byArray[n] = (byte)((WKBReader.hexToInt(string2.charAt(n2)) << 4) + (byte)WKBReader.hexToInt(string2.charAt(n3)));
            ++n;
        }
        throw new IllegalArgumentException("Hex string has odd length");
    }

    private static int hexToInt(char c) {
        int n = Character.digit(c, 16);
        if (n >= 0) {
            return n;
        }
        StringBuilder stringBuilder = new StringBuilder("Invalid hex digit: '");
        stringBuilder.append(c);
        stringBuilder.append("'");
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    private void readCoordinate() throws IOException {
        int n = 0;
        while (n < this.inputDimension) {
            this.ordValues[n] = n <= 1 ? this.precisionModel.makePrecise(this.dis.readDouble()) : this.dis.readDouble();
            ++n;
        }
        return;
    }

    private CoordinateSequence readCoordinateSequence(int n) throws IOException {
        CoordinateSequence coordinateSequence = this.csFactory.create(n, this.inputDimension);
        int n2 = coordinateSequence.getDimension();
        int n3 = this.inputDimension;
        int n4 = n2;
        if (n2 > n3) {
            n4 = n3;
        }
        n3 = 0;
        block0: while (n3 < n) {
            this.readCoordinate();
            n2 = 0;
            while (true) {
                if (n2 >= n4) {
                    ++n3;
                    continue block0;
                }
                coordinateSequence.setOrdinate(n3, n2, this.ordValues[n2]);
                ++n2;
            }
            break;
        }
        return coordinateSequence;
    }

    private CoordinateSequence readCoordinateSequenceLineString(int n) throws IOException {
        CoordinateSequence coordinateSequence = this.readCoordinateSequence(n);
        if (this.isStrict) {
            return coordinateSequence;
        }
        CoordinateSequence coordinateSequence2 = coordinateSequence;
        if (coordinateSequence.size() != 0) {
            coordinateSequence2 = coordinateSequence.size() >= 2 ? coordinateSequence : CoordinateSequences.extend(this.csFactory, coordinateSequence, 2);
        }
        return coordinateSequence2;
    }

    private CoordinateSequence readCoordinateSequenceRing(int n) throws IOException {
        CoordinateSequence coordinateSequence = this.readCoordinateSequence(n);
        if (this.isStrict) {
            return coordinateSequence;
        }
        if (CoordinateSequences.isRing(coordinateSequence)) {
            return coordinateSequence;
        }
        return CoordinateSequences.ensureValidRing(this.csFactory, coordinateSequence);
    }

    private Geometry readGeometry() throws IOException, ParseException {
        int n;
        block19: {
            Object object;
            boolean bl;
            int n2;
            block17: {
                block18: {
                    block16: {
                        n = this.dis.readByte();
                        n2 = 2;
                        bl = true;
                        if (n != 1) break block16;
                        this.dis.setOrder(2);
                        break block17;
                    }
                    if (n != 0) break block18;
                    this.dis.setOrder(1);
                    break block17;
                }
                if (this.isStrict) break block19;
            }
            int n3 = this.dis.readInt();
            int n4 = n3 & 0xFF;
            int n5 = 0;
            n = (Integer.MIN_VALUE & n3) != 0 ? 1 : 0;
            if (n != 0) {
                n2 = 3;
            }
            this.inputDimension = n2;
            if ((n3 & 0x20000000) == 0) {
                bl = false;
            }
            this.hasSRID = bl;
            n = n5;
            if (bl) {
                n = this.dis.readInt();
            }
            if ((object = this.ordValues) == null || ((double[])object).length < this.inputDimension) {
                this.ordValues = new double[this.inputDimension];
            }
            switch (n4) {
                default: {
                    object = new StringBuilder("Unknown WKB type ");
                    ((StringBuilder)object).append(n4);
                    throw new ParseException(((StringBuilder)object).toString());
                }
                case 7: {
                    object = this.readGeometryCollection();
                    break;
                }
                case 6: {
                    object = this.readMultiPolygon();
                    break;
                }
                case 5: {
                    object = this.readMultiLineString();
                    break;
                }
                case 4: {
                    object = this.readMultiPoint();
                    break;
                }
                case 3: {
                    object = this.readPolygon();
                    break;
                }
                case 2: {
                    object = this.readLineString();
                    break;
                }
                case 1: {
                    object = this.readPoint();
                }
            }
            this.setSRID((Geometry)object, n);
            return object;
        }
        StringBuilder stringBuilder = new StringBuilder("Unknown geometry byte order (not NDR or XDR): ");
        stringBuilder.append(n);
        throw new ParseException(stringBuilder.toString());
    }

    private GeometryCollection readGeometryCollection() throws IOException, ParseException {
        int n = this.dis.readInt();
        Geometry[] geometryArray = new Geometry[n];
        int n2 = 0;
        while (n2 < n) {
            geometryArray[n2] = this.readGeometry();
            ++n2;
        }
        return this.factory.createGeometryCollection(geometryArray);
    }

    private LineString readLineString() throws IOException {
        CoordinateSequence coordinateSequence = this.readCoordinateSequenceLineString(this.dis.readInt());
        return this.factory.createLineString(coordinateSequence);
    }

    private LinearRing readLinearRing() throws IOException {
        CoordinateSequence coordinateSequence = this.readCoordinateSequenceRing(this.dis.readInt());
        return this.factory.createLinearRing(coordinateSequence);
    }

    private MultiLineString readMultiLineString() throws IOException, ParseException {
        int n = this.dis.readInt();
        LineString[] lineStringArray = new LineString[n];
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                return this.factory.createMultiLineString(lineStringArray);
            }
            Geometry geometry = this.readGeometry();
            if (!(geometry instanceof LineString)) break;
            lineStringArray[n2] = (LineString)geometry;
            ++n2;
        }
        throw new ParseException("Invalid geometry type encountered in MultiLineString");
    }

    private MultiPoint readMultiPoint() throws IOException, ParseException {
        int n = this.dis.readInt();
        Point[] pointArray = new Point[n];
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                return this.factory.createMultiPoint(pointArray);
            }
            Geometry geometry = this.readGeometry();
            if (!(geometry instanceof Point)) break;
            pointArray[n2] = (Point)geometry;
            ++n2;
        }
        throw new ParseException("Invalid geometry type encountered in MultiPoint");
    }

    private MultiPolygon readMultiPolygon() throws IOException, ParseException {
        int n = this.dis.readInt();
        Polygon[] polygonArray = new Polygon[n];
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                return this.factory.createMultiPolygon(polygonArray);
            }
            Geometry geometry = this.readGeometry();
            if (!(geometry instanceof Polygon)) break;
            polygonArray[n2] = (Polygon)geometry;
            ++n2;
        }
        throw new ParseException("Invalid geometry type encountered in MultiPolygon");
    }

    private Point readPoint() throws IOException {
        CoordinateSequence coordinateSequence = this.readCoordinateSequence(1);
        return this.factory.createPoint(coordinateSequence);
    }

    private Polygon readPolygon() throws IOException {
        int n = this.dis.readInt();
        LinearRing[] linearRingArray = n > 1 ? new LinearRing[n - 1] : null;
        LinearRing linearRing = this.readLinearRing();
        int n2 = 0;
        while (n2 < n - 1) {
            linearRingArray[n2] = this.readLinearRing();
            ++n2;
        }
        return this.factory.createPolygon(linearRing, linearRingArray);
    }

    private Geometry setSRID(Geometry geometry, int n) {
        if (n != 0) {
            geometry.setSRID(n);
        }
        return geometry;
    }

    public Geometry read(InStream inStream) throws IOException, ParseException {
        this.dis.setInStream(inStream);
        return this.readGeometry();
    }

    public Geometry read(byte[] object) throws ParseException {
        try {
            ByteArrayInStream byteArrayInStream = new ByteArrayInStream((byte[])object);
            object = this.read(byteArrayInStream);
            return object;
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder("Unexpected IOException caught: ");
            stringBuilder.append(iOException.getMessage());
            throw new RuntimeException(stringBuilder.toString());
        }
    }
}

