/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ByteOrderValues;
import com.vividsolutions.jts.io.OutStream;
import com.vividsolutions.jts.io.OutputStreamOutStream;
import com.vividsolutions.jts.util.Assert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class WKBWriter {
    private byte[] buf;
    private ByteArrayOutputStream byteArrayOS;
    private OutStream byteArrayOutStream;
    private int byteOrder;
    private boolean includeSRID = false;
    private int outputDimension = 2;

    public WKBWriter() {
        this(2, 1);
    }

    public WKBWriter(int n) {
        this(n, 1);
    }

    public WKBWriter(int n, int n2) {
        this(n, n2, false);
    }

    public WKBWriter(int n, int n2, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream;
        this.byteArrayOS = byteArrayOutputStream = new ByteArrayOutputStream();
        this.byteArrayOutStream = new OutputStreamOutStream(byteArrayOutputStream);
        this.buf = new byte[8];
        this.outputDimension = n;
        this.byteOrder = n2;
        this.includeSRID = bl;
        if (n >= 2 && n <= 3) {
            return;
        }
        throw new IllegalArgumentException("Output dimension must be 2 or 3");
    }

    public WKBWriter(int n, boolean bl) {
        this(n, 1, bl);
    }

    public static String bytesToHex(byte[] byArray) {
        return WKBWriter.toHex(byArray);
    }

    public static String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            stringBuffer.append(WKBWriter.toHexDigit(by >> 4 & 0xF));
            stringBuffer.append(WKBWriter.toHexDigit(by & 0xF));
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static char toHexDigit(int n) {
        if (n >= 0 && n <= 15) {
            if (n <= 9) {
                n += 48;
                return (char)n;
            }
            n = n - 10 + 65;
            return (char)n;
        }
        StringBuilder stringBuilder = new StringBuilder("Nibble value out of range: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    private void writeByteOrder(OutStream outStream) throws IOException {
        this.buf[0] = this.byteOrder == 2 ? (byte)1 : (byte)0;
        outStream.write(this.buf, 1);
    }

    private void writeCoordinate(CoordinateSequence coordinateSequence, int n, OutStream outStream) throws IOException {
        ByteOrderValues.putDouble(coordinateSequence.getX(n), this.buf, this.byteOrder);
        outStream.write(this.buf, 8);
        ByteOrderValues.putDouble(coordinateSequence.getY(n), this.buf, this.byteOrder);
        outStream.write(this.buf, 8);
        if (this.outputDimension >= 3) {
            double d = Double.NaN;
            if (coordinateSequence.getDimension() >= 3) {
                d = coordinateSequence.getOrdinate(n, 2);
            }
            ByteOrderValues.putDouble(d, this.buf, this.byteOrder);
            outStream.write(this.buf, 8);
        }
    }

    private void writeCoordinateSequence(CoordinateSequence coordinateSequence, boolean bl, OutStream outStream) throws IOException {
        if (bl) {
            this.writeInt(coordinateSequence.size(), outStream);
        }
        int n = 0;
        while (n < coordinateSequence.size()) {
            this.writeCoordinate(coordinateSequence, n, outStream);
            ++n;
        }
        return;
    }

    private void writeGeometryCollection(int n, GeometryCollection geometryCollection, OutStream outStream) throws IOException {
        this.writeByteOrder(outStream);
        this.writeGeometryType(n, geometryCollection, outStream);
        this.writeInt(geometryCollection.getNumGeometries(), outStream);
        n = 0;
        while (n < geometryCollection.getNumGeometries()) {
            this.write(geometryCollection.getGeometryN(n), outStream);
            ++n;
        }
        return;
    }

    private void writeGeometryType(int n, Geometry geometry, OutStream outStream) throws IOException {
        int n2 = this.outputDimension;
        int n3 = 0;
        n2 = n2 == 3 ? Integer.MIN_VALUE : 0;
        if (this.includeSRID) {
            n3 = 0x20000000;
        }
        this.writeInt(n | n2 | n3, outStream);
        if (this.includeSRID) {
            this.writeInt(geometry.getSRID(), outStream);
        }
    }

    private void writeInt(int n, OutStream outStream) throws IOException {
        ByteOrderValues.putInt(n, this.buf, this.byteOrder);
        outStream.write(this.buf, 4);
    }

    private void writeLineString(LineString lineString, OutStream outStream) throws IOException {
        this.writeByteOrder(outStream);
        this.writeGeometryType(2, lineString, outStream);
        this.writeCoordinateSequence(lineString.getCoordinateSequence(), true, outStream);
    }

    private void writePoint(Point point, OutStream outStream) throws IOException {
        if (point.getCoordinateSequence().size() != 0) {
            this.writeByteOrder(outStream);
            this.writeGeometryType(1, point, outStream);
            this.writeCoordinateSequence(point.getCoordinateSequence(), false, outStream);
            return;
        }
        throw new IllegalArgumentException("Empty Points cannot be represented in WKB");
    }

    private void writePolygon(Polygon polygon, OutStream outStream) throws IOException {
        this.writeByteOrder(outStream);
        this.writeGeometryType(3, polygon, outStream);
        this.writeInt(polygon.getNumInteriorRing() + 1, outStream);
        this.writeCoordinateSequence(polygon.getExteriorRing().getCoordinateSequence(), true, outStream);
        int n = 0;
        while (n < polygon.getNumInteriorRing()) {
            this.writeCoordinateSequence(polygon.getInteriorRingN(n).getCoordinateSequence(), true, outStream);
            ++n;
        }
        return;
    }

    public void write(Geometry geometry, OutStream outStream) throws IOException {
        if (geometry instanceof Point) {
            this.writePoint((Point)geometry, outStream);
        } else if (geometry instanceof LineString) {
            this.writeLineString((LineString)geometry, outStream);
        } else if (geometry instanceof Polygon) {
            this.writePolygon((Polygon)geometry, outStream);
        } else if (geometry instanceof MultiPoint) {
            this.writeGeometryCollection(4, (MultiPoint)geometry, outStream);
        } else if (geometry instanceof MultiLineString) {
            this.writeGeometryCollection(5, (MultiLineString)geometry, outStream);
        } else if (geometry instanceof MultiPolygon) {
            this.writeGeometryCollection(6, (MultiPolygon)geometry, outStream);
        } else if (geometry instanceof GeometryCollection) {
            this.writeGeometryCollection(7, (GeometryCollection)geometry, outStream);
        } else {
            Assert.shouldNeverReachHere("Unknown Geometry type");
        }
    }

    public byte[] write(Geometry geometry) {
        try {
            this.byteArrayOS.reset();
            this.write(geometry, this.byteArrayOutStream);
            return this.byteArrayOS.toByteArray();
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder("Unexpected IO exception: ");
            stringBuilder.append(iOException.getMessage());
            throw new RuntimeException(stringBuilder.toString());
        }
    }
}

