/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;

public class WKTFileReader {
    private static final int MAX_LOOKAHEAD = 1000;
    private int count = 0;
    private File file = null;
    private int limit = -1;
    private int offset = 0;
    private Reader reader;
    private WKTReader wktReader;

    public WKTFileReader(File file, WKTReader wKTReader) {
        this.file = file;
        this.wktReader = wKTReader;
    }

    public WKTFileReader(Reader reader, WKTReader wKTReader) {
        this.reader = reader;
        this.wktReader = wKTReader;
    }

    public WKTFileReader(String string2, WKTReader wKTReader) {
        this(new File(string2), wKTReader);
    }

    private boolean isAtEndOfFile(BufferedReader bufferedReader) throws IOException {
        bufferedReader.mark(1000);
        if (new StreamTokenizer(bufferedReader).nextToken() == -1) {
            return true;
        }
        bufferedReader.reset();
        return false;
    }

    private boolean isAtLimit(List list) {
        if (this.limit < 0) {
            return false;
        }
        return list.size() >= this.limit;
    }

    private List read(BufferedReader bufferedReader) throws IOException, ParseException {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        while (!this.isAtEndOfFile(bufferedReader) && !this.isAtLimit(arrayList)) {
            Geometry geometry = this.wktReader.read(bufferedReader);
            if (this.count >= this.offset) {
                arrayList.add(geometry);
            }
            ++this.count;
        }
        return arrayList;
    }

    /*
     * Loose catch block
     */
    public List read() throws IOException, ParseException {
        List list;
        if (this.file != null) {
            this.reader = new FileReader(this.file);
        }
        this.count = 0;
        BufferedReader bufferedReader = new BufferedReader(this.reader);
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        try {
            list = this.read(bufferedReader);
        }
        catch (Throwable throwable) {
            bufferedReader.close();
            throw throwable;
        }
        try {
            bufferedReader.close();
            return list;
        }
        finally {
            this.reader.close();
        }
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public void setOffset(int n) {
        this.offset = n;
    }
}

