/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.linearref;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.linearref.LinearIterator;
import com.vividsolutions.jts.util.Assert;

class LengthIndexOfPoint {
    private Geometry linearGeom;

    public LengthIndexOfPoint(Geometry geometry) {
        this.linearGeom = geometry;
    }

    public static double indexOf(Geometry geometry, Coordinate coordinate) {
        return new LengthIndexOfPoint(geometry).indexOf(coordinate);
    }

    public static double indexOfAfter(Geometry geometry, Coordinate coordinate, double d) {
        return new LengthIndexOfPoint(geometry).indexOfAfter(coordinate, d);
    }

    private double indexOfFromStart(Coordinate coordinate, double d) {
        LineSegment lineSegment = new LineSegment();
        LinearIterator linearIterator = new LinearIterator(this.linearGeom);
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        double d4 = d;
        while (linearIterator.hasNext()) {
            double d5 = d2;
            double d6 = d3;
            double d7 = d4;
            if (!linearIterator.isEndOfLine()) {
                lineSegment.p0 = linearIterator.getSegmentStart();
                lineSegment.p1 = linearIterator.getSegmentEnd();
                double d8 = lineSegment.distance(coordinate);
                d6 = this.segmentNearestMeasure(lineSegment, coordinate, d3);
                d5 = d2;
                d7 = d4;
                if (d8 < d2) {
                    d5 = d2;
                    d7 = d4;
                    if (d6 > d) {
                        d5 = d8;
                        d7 = d6;
                    }
                }
                d6 = d3 + lineSegment.getLength();
            }
            linearIterator.next();
            d2 = d5;
            d3 = d6;
            d4 = d7;
        }
        return d4;
    }

    private double segmentNearestMeasure(LineSegment lineSegment, Coordinate coordinate, double d) {
        double d2 = lineSegment.projectionFactor(coordinate);
        if (d2 <= 0.0) {
            return d;
        }
        if (d2 <= 1.0) {
            return d + d2 * lineSegment.getLength();
        }
        return d + lineSegment.getLength();
    }

    public double indexOf(Coordinate coordinate) {
        return this.indexOfFromStart(coordinate, -1.0);
    }

    public double indexOfAfter(Coordinate coordinate, double d) {
        if (d < 0.0) {
            return this.indexOf(coordinate);
        }
        double d2 = this.linearGeom.getLength();
        if (d2 < d) {
            return d2;
        }
        d2 = this.indexOfFromStart(coordinate, d);
        boolean bl = d2 >= d;
        Assert.isTrue(bl, "computed index is before specified minimum index");
        return d2;
    }
}

