/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.linearref;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.linearref.LinearIterator;
import com.vividsolutions.jts.linearref.LinearLocation;

public class LengthLocationMap {
    private Geometry linearGeom;

    public LengthLocationMap(Geometry geometry) {
        this.linearGeom = geometry;
    }

    public static double getLength(Geometry geometry, LinearLocation linearLocation) {
        return new LengthLocationMap(geometry).getLength(linearLocation);
    }

    public static LinearLocation getLocation(Geometry geometry, double d) {
        return new LengthLocationMap(geometry).getLocation(d);
    }

    public static LinearLocation getLocation(Geometry geometry, double d, boolean bl) {
        return new LengthLocationMap(geometry).getLocation(d, bl);
    }

    private LinearLocation getLocationForward(double d) {
        if (d <= 0.0) {
            return new LinearLocation();
        }
        LinearIterator linearIterator = new LinearIterator(this.linearGeom);
        double d2 = 0.0;
        while (linearIterator.hasNext()) {
            double d3;
            if (linearIterator.isEndOfLine()) {
                d3 = d2;
                if (d2 == d) {
                    return new LinearLocation(linearIterator.getComponentIndex(), linearIterator.getVertexIndex(), 0.0);
                }
            } else {
                Coordinate coordinate = linearIterator.getSegmentStart();
                double d4 = linearIterator.getSegmentEnd().distance(coordinate);
                d3 = d2 + d4;
                if (d3 > d) {
                    d = (d - d2) / d4;
                    return new LinearLocation(linearIterator.getComponentIndex(), linearIterator.getVertexIndex(), d);
                }
            }
            linearIterator.next();
            d2 = d3;
        }
        return LinearLocation.getEndLocation(this.linearGeom);
    }

    private LinearLocation resolveHigher(LinearLocation linearLocation) {
        int n;
        if (!linearLocation.isEndpoint(this.linearGeom)) {
            return linearLocation;
        }
        int n2 = n = linearLocation.getComponentIndex();
        if (n >= this.linearGeom.getNumGeometries() - 1) {
            return linearLocation;
        }
        while ((n = n2 + 1) < this.linearGeom.getNumGeometries() - 1) {
            n2 = n;
            if (this.linearGeom.getGeometryN(n).getLength() == 0.0) continue;
        }
        return new LinearLocation(n, 0, 0.0);
    }

    public double getLength(LinearLocation linearLocation) {
        LinearIterator linearIterator = new LinearIterator(this.linearGeom);
        double d = 0.0;
        while (linearIterator.hasNext()) {
            double d2 = d;
            if (!linearIterator.isEndOfLine()) {
                Coordinate coordinate = linearIterator.getSegmentStart();
                d2 = linearIterator.getSegmentEnd().distance(coordinate);
                if (linearLocation.getComponentIndex() == linearIterator.getComponentIndex() && linearLocation.getSegmentIndex() == linearIterator.getVertexIndex()) {
                    return d + d2 * linearLocation.getSegmentFraction();
                }
                d2 = d + d2;
            }
            linearIterator.next();
            d = d2;
        }
        return d;
    }

    public LinearLocation getLocation(double d) {
        return this.getLocation(d, true);
    }

    public LinearLocation getLocation(double d, boolean bl) {
        double d2 = d;
        if (d < 0.0) {
            d2 = d + this.linearGeom.getLength();
        }
        LinearLocation linearLocation = this.getLocationForward(d2);
        if (bl) {
            return linearLocation;
        }
        return this.resolveHigher(linearLocation);
    }
}

