/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.linearref;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.linearref.ExtractLineByLocation;
import com.vividsolutions.jts.linearref.LinearLocation;
import com.vividsolutions.jts.linearref.LocationIndexOfLine;
import com.vividsolutions.jts.linearref.LocationIndexOfPoint;

public class LocationIndexedLine {
    private Geometry linearGeom;

    public LocationIndexedLine(Geometry geometry) {
        this.linearGeom = geometry;
        this.checkGeometryType();
    }

    private void checkGeometryType() {
        Geometry geometry = this.linearGeom;
        if (!(geometry instanceof LineString) && !(geometry instanceof MultiLineString)) {
            throw new IllegalArgumentException("Input geometry must be linear");
        }
    }

    public LinearLocation clampIndex(LinearLocation linearLocation) {
        linearLocation = (LinearLocation)linearLocation.clone();
        linearLocation.clamp(this.linearGeom);
        return linearLocation;
    }

    public Geometry extractLine(LinearLocation linearLocation, LinearLocation linearLocation2) {
        return ExtractLineByLocation.extract(this.linearGeom, linearLocation, linearLocation2);
    }

    public Coordinate extractPoint(LinearLocation linearLocation) {
        return linearLocation.getCoordinate(this.linearGeom);
    }

    public Coordinate extractPoint(LinearLocation linearLocation, double d) {
        linearLocation = linearLocation.toLowest(this.linearGeom);
        return linearLocation.getSegment(this.linearGeom).pointAlongOffset(linearLocation.getSegmentFraction(), d);
    }

    public LinearLocation getEndIndex() {
        return LinearLocation.getEndLocation(this.linearGeom);
    }

    public LinearLocation getStartIndex() {
        return new LinearLocation();
    }

    public LinearLocation indexOf(Coordinate coordinate) {
        return LocationIndexOfPoint.indexOf(this.linearGeom, coordinate);
    }

    public LinearLocation indexOfAfter(Coordinate coordinate, LinearLocation linearLocation) {
        return LocationIndexOfPoint.indexOfAfter(this.linearGeom, coordinate, linearLocation);
    }

    public LinearLocation[] indicesOf(Geometry geometry) {
        return LocationIndexOfLine.indicesOf(this.linearGeom, geometry);
    }

    public boolean isValidIndex(LinearLocation linearLocation) {
        return linearLocation.isValid(this.linearGeom);
    }

    public LinearLocation project(Coordinate coordinate) {
        return LocationIndexOfPoint.indexOf(this.linearGeom, coordinate);
    }
}

