/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.math;

import com.vividsolutions.jts.algorithm.Angle;
import com.vividsolutions.jts.algorithm.RobustDeterminant;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.util.Assert;

public class Vector2D {
    private double x;
    private double y;

    public Vector2D() {
        this(0.0, 0.0);
    }

    public Vector2D(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Vector2D(Coordinate coordinate) {
        this.x = coordinate.x;
        this.y = coordinate.y;
    }

    public Vector2D(Coordinate coordinate, Coordinate coordinate2) {
        this.x = coordinate2.x - coordinate.x;
        this.y = coordinate2.y - coordinate.y;
    }

    public Vector2D(Vector2D vector2D) {
        this.x = vector2D.x;
        this.y = vector2D.y;
    }

    public static Vector2D create(double d, double d2) {
        return new Vector2D(d, d2);
    }

    public static Vector2D create(Coordinate coordinate) {
        return new Vector2D(coordinate);
    }

    public static Vector2D create(Coordinate coordinate, Coordinate coordinate2) {
        return new Vector2D(coordinate, coordinate2);
    }

    public static Vector2D create(Vector2D vector2D) {
        return new Vector2D(vector2D);
    }

    public Vector2D add(Vector2D vector2D) {
        return Vector2D.create(this.x + vector2D.x, this.y + vector2D.y);
    }

    public double angle() {
        return Math.atan2(this.y, this.x);
    }

    public double angle(Vector2D vector2D) {
        return Angle.diff(vector2D.angle(), this.angle());
    }

    public double angleTo(Vector2D vector2D) {
        double d = this.angle();
        double d2 = vector2D.angle() - d;
        if (d2 <= -Math.PI) {
            return d2 + Math.PI * 2;
        }
        d = d2;
        if (d2 > Math.PI) {
            d = d2 - Math.PI * 2;
        }
        return d;
    }

    public Vector2D average(Vector2D vector2D) {
        return this.weightedSum(vector2D, 0.5);
    }

    public Object clone() {
        return new Vector2D(this);
    }

    public double distance(Vector2D vector2D) {
        double d = vector2D.x - this.x;
        double d2 = vector2D.y - this.y;
        return Math.sqrt(d * d + d2 * d2);
    }

    public Vector2D divide(double d) {
        return Vector2D.create(this.x / d, this.y / d);
    }

    public double dot(Vector2D vector2D) {
        return this.x * vector2D.x + this.y * vector2D.y;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Vector2D)) {
            return false;
        }
        object = (Vector2D)object;
        return this.x == ((Vector2D)object).x && this.y == ((Vector2D)object).y;
    }

    public double getComponent(int n) {
        if (n == 0) {
            return this.x;
        }
        return this.y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int hashCode() {
        return (629 + Coordinate.hashCode(this.x)) * 37 + Coordinate.hashCode(this.y);
    }

    public boolean isParallel(Vector2D vector2D) {
        return 0.0 == (double)RobustDeterminant.signOfDet2x2(this.x, this.y, vector2D.x, vector2D.y);
    }

    public double length() {
        double d = this.x;
        double d2 = this.y;
        return Math.sqrt(d * d + d2 * d2);
    }

    public double lengthSquared() {
        double d = this.x;
        double d2 = this.y;
        return d * d + d2 * d2;
    }

    public Vector2D multiply(double d) {
        return Vector2D.create(this.x * d, this.y * d);
    }

    public Vector2D negate() {
        return Vector2D.create(-this.x, -this.y);
    }

    public Vector2D normalize() {
        double d = this.length();
        if (d > 0.0) {
            return this.divide(d);
        }
        return Vector2D.create(0.0, 0.0);
    }

    public Vector2D rotate(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.x;
        d = this.y;
        return Vector2D.create(d4 * d2 - d * d3, d4 * d3 + d * d2);
    }

    public Vector2D rotateByQuarterCircle(int n) {
        int n2;
        int n3 = n2 = n % 4;
        if (n < 0) {
            n3 = n2;
            if (n2 != 0) {
                n3 = n2 + 4;
            }
        }
        if (n3 != 0) {
            if (n3 != 1) {
                if (n3 != 2) {
                    if (n3 != 3) {
                        Assert.shouldNeverReachHere();
                        return null;
                    }
                    return Vector2D.create(this.y, -this.x);
                }
                return Vector2D.create(-this.x, -this.y);
            }
            return Vector2D.create(-this.y, this.x);
        }
        return Vector2D.create(this.x, this.y);
    }

    public Vector2D subtract(Vector2D vector2D) {
        return Vector2D.create(this.x - vector2D.x, this.y - vector2D.y);
    }

    public Coordinate toCoordinate() {
        return new Coordinate(this.x, this.y);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        stringBuilder.append(this.x);
        stringBuilder.append(", ");
        stringBuilder.append(this.y);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public Coordinate translate(Coordinate coordinate) {
        return new Coordinate(this.x + coordinate.x, this.y + coordinate.y);
    }

    public Vector2D weightedSum(Vector2D vector2D, double d) {
        double d2 = this.x;
        double d3 = 1.0 - d;
        return Vector2D.create(d2 * d + vector2D.x * d3, d * this.y + d3 * vector2D.y);
    }
}

