/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.SegmentIntersector;
import com.vividsolutions.jts.noding.SegmentString;
import java.util.ArrayList;
import java.util.List;

public class InteriorIntersectionFinderAdder
implements SegmentIntersector {
    private final List interiorIntersections;
    private LineIntersector li;

    public InteriorIntersectionFinderAdder(LineIntersector lineIntersector) {
        this.li = lineIntersector;
        this.interiorIntersections = new ArrayList();
    }

    public List getInteriorIntersections() {
        return this.interiorIntersections;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public void processIntersections(SegmentString segmentString, int n, SegmentString segmentString2, int n2) {
        if (segmentString == segmentString2 && n == n2) {
            return;
        }
        Coordinate coordinate = segmentString.getCoordinates()[n];
        Coordinate coordinate2 = segmentString.getCoordinates()[n + 1];
        Coordinate coordinate3 = segmentString2.getCoordinates()[n2];
        Coordinate coordinate4 = segmentString2.getCoordinates()[n2 + 1];
        this.li.computeIntersection(coordinate, coordinate2, coordinate3, coordinate4);
        if (this.li.hasIntersection() && this.li.isInteriorIntersection()) {
            int n3 = 0;
            while (true) {
                if (n3 >= this.li.getIntersectionNum()) {
                    ((NodedSegmentString)segmentString).addIntersections(this.li, n, 0);
                    ((NodedSegmentString)segmentString2).addIntersections(this.li, n2, 1);
                    break;
                }
                this.interiorIntersections.add(this.li.getIntersection(n3));
                ++n3;
            }
        }
    }
}

