/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.noding.NodableSegmentString;
import com.vividsolutions.jts.noding.Octant;
import com.vividsolutions.jts.noding.SegmentNode;
import com.vividsolutions.jts.noding.SegmentNodeList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodedSegmentString
implements NodableSegmentString {
    private Object data;
    private SegmentNodeList nodeList = new SegmentNodeList(this);
    private Coordinate[] pts;

    public NodedSegmentString(Coordinate[] coordinateArray, Object object) {
        this.pts = coordinateArray;
        this.data = object;
    }

    public static List getNodedSubstrings(Collection collection) {
        ArrayList arrayList = new ArrayList();
        NodedSegmentString.getNodedSubstrings(collection, arrayList);
        return arrayList;
    }

    public static void getNodedSubstrings(Collection object, Collection collection) {
        object = object.iterator();
        while (object.hasNext()) {
            ((NodedSegmentString)object.next()).getNodeList().addSplitEdges(collection);
        }
        return;
    }

    private int safeOctant(Coordinate coordinate, Coordinate coordinate2) {
        if (coordinate.equals2D(coordinate2)) {
            return 0;
        }
        return Octant.octant(coordinate, coordinate2);
    }

    public void addIntersection(LineIntersector lineIntersector, int n, int n2, int n3) {
        this.addIntersection(new Coordinate(lineIntersector.getIntersection(n3)), n);
    }

    @Override
    public void addIntersection(Coordinate coordinate, int n) {
        this.addIntersectionNode(coordinate, n);
    }

    public SegmentNode addIntersectionNode(Coordinate coordinate, int n) {
        int n2 = n + 1;
        Coordinate[] coordinateArray = this.pts;
        int n3 = n;
        if (n2 < coordinateArray.length) {
            n3 = n;
            if (coordinate.equals2D(coordinateArray[n2])) {
                n3 = n2;
            }
        }
        return this.nodeList.add(coordinate, n3);
    }

    public void addIntersections(LineIntersector lineIntersector, int n, int n2) {
        int n3 = 0;
        while (n3 < lineIntersector.getIntersectionNum()) {
            this.addIntersection(lineIntersector, n, n2, n3);
            ++n3;
        }
        return;
    }

    @Override
    public Coordinate getCoordinate(int n) {
        return this.pts[n];
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public SegmentNodeList getNodeList() {
        return this.nodeList;
    }

    public int getSegmentOctant(int n) {
        if (n == this.pts.length - 1) {
            return -1;
        }
        return this.safeOctant(this.getCoordinate(n), this.getCoordinate(n + 1));
    }

    @Override
    public boolean isClosed() {
        Coordinate[] coordinateArray = this.pts;
        return coordinateArray[0].equals(coordinateArray[coordinateArray.length - 1]);
    }

    @Override
    public void setData(Object object) {
        this.data = object;
    }

    @Override
    public int size() {
        return this.pts.length;
    }

    public String toString() {
        return WKTWriter.toLineString(new CoordinateArraySequence(this.pts));
    }
}

