/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.SegmentNode;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.util.Assert;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SegmentNodeList {
    private NodedSegmentString edge;
    private Map nodeMap = new TreeMap();

    public SegmentNodeList(NodedSegmentString nodedSegmentString) {
        this.edge = nodedSegmentString;
    }

    private void addCollapsedNodes() {
        Object object = new ArrayList();
        this.findCollapsesFromInsertedNodes((List)object);
        this.findCollapsesFromExistingVertices((List)object);
        object = object.iterator();
        while (object.hasNext()) {
            int n = (Integer)object.next();
            this.add(this.edge.getCoordinate(n), n);
        }
        return;
    }

    private void addEdgeCoordinates(SegmentNode segmentNode, SegmentNode segmentNode2, CoordinateList coordinateList) {
        int n = segmentNode2.segmentIndex;
        n = segmentNode.segmentIndex;
        Coordinate coordinate = this.edge.getCoordinate(segmentNode2.segmentIndex);
        n = !segmentNode2.isInterior() && segmentNode2.coord.equals2D(coordinate) ? 0 : 1;
        coordinateList.add(new Coordinate(segmentNode.coord), false);
        int n2 = segmentNode.segmentIndex + 1;
        while (true) {
            if (n2 > segmentNode2.segmentIndex) {
                if (n != 0) {
                    coordinateList.add(new Coordinate(segmentNode2.coord));
                }
                return;
            }
            coordinateList.add(this.edge.getCoordinate(n2));
            ++n2;
        }
    }

    private void addEndpoints() {
        int n = this.edge.size() - 1;
        this.add(this.edge.getCoordinate(0), 0);
        this.add(this.edge.getCoordinate(n), n);
    }

    private void checkSplitEdgesCorrectness(List object) {
        Object object2 = this.edge.getCoordinates();
        Coordinate coordinate = ((SegmentString)object.get(0)).getCoordinate(0);
        if (coordinate.equals2D(object2[0])) {
            object = ((SegmentString)object.get(object.size() - 1)).getCoordinates();
            if (((Coordinate)(object = object[((Coordinate[])object).length - 1])).equals2D(object2[((Coordinate[])object2).length - 1])) {
                return;
            }
            object2 = new StringBuilder("bad split edge end point at ");
            ((StringBuilder)object2).append(object);
            throw new RuntimeException(((StringBuilder)object2).toString());
        }
        object = new StringBuilder("bad split edge start point at ");
        ((StringBuilder)object).append(coordinate);
        throw new RuntimeException(((StringBuilder)object).toString());
    }

    private boolean findCollapseIndex(SegmentNode segmentNode, SegmentNode segmentNode2, int[] nArray) {
        int n;
        if (!segmentNode.coord.equals2D(segmentNode2.coord)) {
            return false;
        }
        int n2 = n = segmentNode2.segmentIndex - segmentNode.segmentIndex;
        if (!segmentNode2.isInterior()) {
            n2 = n - 1;
        }
        if (n2 == 1) {
            nArray[0] = segmentNode.segmentIndex + 1;
            return true;
        }
        return false;
    }

    private void findCollapsesFromExistingVertices(List list) {
        int n = 0;
        while (n < this.edge.size() - 2) {
            Coordinate coordinate = this.edge.getCoordinate(n);
            NodedSegmentString nodedSegmentString = this.edge;
            int n2 = n + 1;
            nodedSegmentString.getCoordinate(n2);
            if (coordinate.equals2D(this.edge.getCoordinate(n + 2))) {
                list.add(new Integer(n2));
            }
            n = n2;
        }
        return;
    }

    private void findCollapsesFromInsertedNodes(List list) {
        int[] nArray = new int[1];
        Iterator iterator2 = this.iterator();
        SegmentNode segmentNode = (SegmentNode)iterator2.next();
        while (iterator2.hasNext()) {
            SegmentNode segmentNode2 = (SegmentNode)iterator2.next();
            if (this.findCollapseIndex(segmentNode, segmentNode2, nArray)) {
                list.add(new Integer(nArray[0]));
            }
            segmentNode = segmentNode2;
        }
        return;
    }

    public SegmentNode add(Coordinate coordinate, int n) {
        Object object = this.edge;
        SegmentNode segmentNode = new SegmentNode((NodedSegmentString)object, coordinate, n, ((NodedSegmentString)object).getSegmentOctant(n));
        if ((object = (SegmentNode)this.nodeMap.get(segmentNode)) != null) {
            Assert.isTrue(((SegmentNode)object).coord.equals2D(coordinate), "Found equal nodes with different coordinates");
            return object;
        }
        this.nodeMap.put(segmentNode, segmentNode);
        return segmentNode;
    }

    public void addSplitEdges(Collection collection) {
        this.addEndpoints();
        this.addCollapsedNodes();
        Iterator iterator2 = this.iterator();
        SegmentNode segmentNode = (SegmentNode)iterator2.next();
        while (iterator2.hasNext()) {
            SegmentNode segmentNode2 = (SegmentNode)iterator2.next();
            collection.add(this.createSplitEdge(segmentNode, segmentNode2));
            segmentNode = segmentNode2;
        }
        return;
    }

    SegmentString createSplitEdge(SegmentNode segmentNode, SegmentNode segmentNode2) {
        int n = segmentNode2.segmentIndex - segmentNode.segmentIndex + 2;
        Coordinate[] coordinateArray = this.edge.getCoordinate(segmentNode2.segmentIndex);
        boolean bl = segmentNode2.isInterior();
        int n2 = 1;
        boolean bl2 = bl || !segmentNode2.coord.equals2D((Coordinate)coordinateArray);
        int n3 = n;
        if (!bl2) {
            n3 = n - 1;
        }
        coordinateArray = new Coordinate[n3];
        coordinateArray[0] = new Coordinate(segmentNode.coord);
        n3 = segmentNode.segmentIndex + 1;
        while (true) {
            if (n3 > segmentNode2.segmentIndex) {
                if (bl2) {
                    coordinateArray[n2] = new Coordinate(segmentNode2.coord);
                }
                return new NodedSegmentString(coordinateArray, this.edge.getData());
            }
            coordinateArray[n2] = this.edge.getCoordinate(n3);
            ++n3;
            ++n2;
        }
    }

    public NodedSegmentString getEdge() {
        return this.edge;
    }

    public Coordinate[] getSplitCoordinates() {
        CoordinateList coordinateList = new CoordinateList();
        this.addEndpoints();
        Iterator iterator2 = this.iterator();
        SegmentNode segmentNode = (SegmentNode)iterator2.next();
        while (iterator2.hasNext()) {
            SegmentNode segmentNode2 = (SegmentNode)iterator2.next();
            this.addEdgeCoordinates(segmentNode, segmentNode2, coordinateList);
            segmentNode = segmentNode2;
        }
        return coordinateList.toCoordinateArray();
    }

    public Iterator iterator() {
        return this.nodeMap.values().iterator();
    }

    public void print(PrintStream printStream) {
        printStream.println("Intersections:");
        Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            ((SegmentNode)iterator2.next()).print(printStream);
        }
        return;
    }
}

