/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.util.Assert;

public class SegmentPointComparator {
    public static int compare(int n, Coordinate coordinate, Coordinate coordinate2) {
        if (coordinate.equals2D(coordinate2)) {
            return 0;
        }
        int n2 = SegmentPointComparator.relativeSign(coordinate.x, coordinate2.x);
        int n3 = SegmentPointComparator.relativeSign(coordinate.y, coordinate2.y);
        switch (n) {
            default: {
                Assert.shouldNeverReachHere("invalid octant value");
                return 0;
            }
            case 7: {
                return SegmentPointComparator.compareValue(n2, -n3);
            }
            case 6: {
                return SegmentPointComparator.compareValue(-n3, n2);
            }
            case 5: {
                return SegmentPointComparator.compareValue(-n3, -n2);
            }
            case 4: {
                return SegmentPointComparator.compareValue(-n2, -n3);
            }
            case 3: {
                return SegmentPointComparator.compareValue(-n2, n3);
            }
            case 2: {
                return SegmentPointComparator.compareValue(n3, -n2);
            }
            case 1: {
                return SegmentPointComparator.compareValue(n3, n2);
            }
            case 0: 
        }
        return SegmentPointComparator.compareValue(n2, n3);
    }

    private static int compareValue(int n, int n2) {
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 > 0) {
            return 1;
        }
        return 0;
    }

    public static int relativeSign(double d, double d2) {
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        return 0;
    }
}

