/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.noding.OrientedCoordinateArray;
import com.vividsolutions.jts.noding.SegmentString;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class SegmentStringDissolver {
    private SegmentStringMerger merger;
    private Map ocaMap = new TreeMap();

    public SegmentStringDissolver() {
        this(null);
    }

    public SegmentStringDissolver(SegmentStringMerger segmentStringMerger) {
        this.merger = segmentStringMerger;
    }

    private void add(OrientedCoordinateArray orientedCoordinateArray, SegmentString segmentString) {
        this.ocaMap.put(orientedCoordinateArray, segmentString);
    }

    private SegmentString findMatching(OrientedCoordinateArray orientedCoordinateArray, SegmentString segmentString) {
        return (SegmentString)this.ocaMap.get(orientedCoordinateArray);
    }

    public void dissolve(SegmentString segmentString) {
        OrientedCoordinateArray orientedCoordinateArray = new OrientedCoordinateArray(segmentString.getCoordinates());
        SegmentString segmentString2 = this.findMatching(orientedCoordinateArray, segmentString);
        if (segmentString2 == null) {
            this.add(orientedCoordinateArray, segmentString);
        } else if (this.merger != null) {
            boolean bl = CoordinateArrays.equals(segmentString2.getCoordinates(), segmentString.getCoordinates());
            this.merger.merge(segmentString2, segmentString, bl);
        }
    }

    public void dissolve(Collection object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.dissolve((SegmentString)object.next());
        }
        return;
    }

    public Collection getDissolved() {
        return this.ocaMap.values();
    }

    public static interface SegmentStringMerger {
        public void merge(SegmentString var1, SegmentString var2, boolean var3);
    }
}

