/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding.snapround;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.util.Assert;

public class HotPixel {
    private static final double SAFE_ENV_EXPANSION_FACTOR = 0.75;
    private Coordinate[] corner = new Coordinate[4];
    private LineIntersector li;
    private double maxx;
    private double maxy;
    private double minx;
    private double miny;
    private Coordinate originalPt;
    private Coordinate p0Scaled;
    private Coordinate p1Scaled;
    private Coordinate pt;
    private Coordinate ptScaled;
    private Envelope safeEnv = null;
    private double scaleFactor;

    public HotPixel(Coordinate coordinate, double d, LineIntersector lineIntersector) {
        this.originalPt = coordinate;
        this.pt = coordinate;
        this.scaleFactor = d;
        this.li = lineIntersector;
        if (!(d <= 0.0)) {
            if (d != 1.0) {
                this.pt = new Coordinate(this.scale(coordinate.x), this.scale(coordinate.y));
                this.p0Scaled = new Coordinate();
                this.p1Scaled = new Coordinate();
            }
            this.initCorners(this.pt);
            return;
        }
        throw new IllegalArgumentException("Scale factor must be non-zero");
    }

    private void copyScaled(Coordinate coordinate, Coordinate coordinate2) {
        coordinate2.x = this.scale(coordinate.x);
        coordinate2.y = this.scale(coordinate.y);
    }

    private void initCorners(Coordinate coordinate) {
        double d;
        this.minx = coordinate.x - 0.5;
        this.maxx = coordinate.x + 0.5;
        this.miny = coordinate.y - 0.5;
        this.maxy = d = coordinate.y + 0.5;
        this.corner[0] = new Coordinate(this.maxx, d);
        this.corner[1] = new Coordinate(this.minx, this.maxy);
        this.corner[2] = new Coordinate(this.minx, this.miny);
        this.corner[3] = new Coordinate(this.maxx, this.miny);
    }

    private boolean intersectsPixelClosure(Coordinate coordinate, Coordinate coordinate2) {
        Coordinate[] coordinateArray = this.li;
        Object object = this.corner;
        coordinateArray.computeIntersection(coordinate, coordinate2, object[0], object[1]);
        if (this.li.hasIntersection()) {
            return true;
        }
        object = this.li;
        coordinateArray = this.corner;
        ((LineIntersector)object).computeIntersection(coordinate, coordinate2, coordinateArray[1], coordinateArray[2]);
        if (this.li.hasIntersection()) {
            return true;
        }
        object = this.li;
        coordinateArray = this.corner;
        ((LineIntersector)object).computeIntersection(coordinate, coordinate2, coordinateArray[2], coordinateArray[3]);
        if (this.li.hasIntersection()) {
            return true;
        }
        object = this.li;
        coordinateArray = this.corner;
        ((LineIntersector)object).computeIntersection(coordinate, coordinate2, coordinateArray[3], coordinateArray[0]);
        return this.li.hasIntersection();
    }

    private boolean intersectsScaled(Coordinate coordinate, Coordinate coordinate2) {
        double d = Math.min(coordinate.x, coordinate2.x);
        double d2 = Math.max(coordinate.x, coordinate2.x);
        double d3 = Math.min(coordinate.y, coordinate2.y);
        double d4 = Math.max(coordinate.y, coordinate2.y);
        double d5 = this.maxx;
        boolean bl = true;
        boolean bl2 = d5 < d || this.minx > d2 || this.maxy < d3 || this.miny > d4;
        if (bl2) {
            return false;
        }
        boolean bl3 = this.intersectsToleranceSquare(coordinate, coordinate2);
        boolean bl4 = bl;
        if (bl2) {
            bl4 = bl;
            if (bl3) {
                bl4 = false;
            }
        }
        Assert.isTrue(bl4, "Found bad envelope test");
        return bl3;
    }

    private boolean intersectsToleranceSquare(Coordinate coordinate, Coordinate coordinate2) {
        Coordinate[] coordinateArray = this.li;
        Object object = this.corner;
        coordinateArray.computeIntersection(coordinate, coordinate2, object[0], object[1]);
        if (this.li.isProper()) {
            return true;
        }
        coordinateArray = this.li;
        object = this.corner;
        coordinateArray.computeIntersection(coordinate, coordinate2, object[1], object[2]);
        if (this.li.isProper()) {
            return true;
        }
        boolean bl = this.li.hasIntersection();
        coordinateArray = this.li;
        object = this.corner;
        coordinateArray.computeIntersection(coordinate, coordinate2, object[2], object[3]);
        if (this.li.isProper()) {
            return true;
        }
        boolean bl2 = this.li.hasIntersection();
        object = this.li;
        coordinateArray = this.corner;
        ((LineIntersector)object).computeIntersection(coordinate, coordinate2, coordinateArray[3], coordinateArray[0]);
        if (this.li.isProper()) {
            return true;
        }
        if (bl && bl2) {
            return true;
        }
        if (coordinate.equals(this.pt)) {
            return true;
        }
        return coordinate2.equals(this.pt);
    }

    private double scale(double d) {
        return Math.round(d * this.scaleFactor);
    }

    public boolean addSnappedNode(NodedSegmentString nodedSegmentString, int n) {
        if (this.intersects(nodedSegmentString.getCoordinate(n), nodedSegmentString.getCoordinate(n + 1))) {
            nodedSegmentString.addIntersection(this.getCoordinate(), n);
            return true;
        }
        return false;
    }

    public Coordinate getCoordinate() {
        return this.originalPt;
    }

    public Envelope getSafeEnvelope() {
        if (this.safeEnv == null) {
            double d = 0.75 / this.scaleFactor;
            this.safeEnv = new Envelope(this.originalPt.x - d, this.originalPt.x + d, this.originalPt.y - d, this.originalPt.y + d);
        }
        return this.safeEnv;
    }

    public boolean intersects(Coordinate coordinate, Coordinate coordinate2) {
        if (this.scaleFactor == 1.0) {
            return this.intersectsScaled(coordinate, coordinate2);
        }
        this.copyScaled(coordinate, this.p0Scaled);
        this.copyScaled(coordinate2, this.p1Scaled);
        return this.intersectsScaled(this.p0Scaled, this.p1Scaled);
    }
}

