/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding.snapround;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.noding.InteriorIntersectionFinderAdder;
import com.vividsolutions.jts.noding.MCIndexNoder;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.Noder;
import com.vividsolutions.jts.noding.NodingValidator;
import com.vividsolutions.jts.noding.SegmentIntersector;
import com.vividsolutions.jts.noding.snapround.HotPixel;
import com.vividsolutions.jts.noding.snapround.MCIndexPointSnapper;
import java.util.Collection;
import java.util.List;

public class MCIndexSnapRounder
implements Noder {
    private LineIntersector li;
    private Collection nodedSegStrings;
    private MCIndexNoder noder;
    private final PrecisionModel pm;
    private MCIndexPointSnapper pointSnapper;
    private final double scaleFactor;

    public MCIndexSnapRounder(PrecisionModel precisionModel) {
        this.pm = precisionModel;
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        this.li = robustLineIntersector;
        robustLineIntersector.setPrecisionModel(precisionModel);
        this.scaleFactor = precisionModel.getScale();
    }

    private void checkCorrectness(Collection object) {
        object = new NodingValidator(NodedSegmentString.getNodedSubstrings((Collection)object));
        try {
            ((NodingValidator)object).checkValid();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void computeIntersectionSnaps(Collection object) {
        object = object.iterator();
        while (object.hasNext()) {
            HotPixel hotPixel = new HotPixel((Coordinate)object.next(), this.scaleFactor, this.li);
            this.pointSnapper.snap(hotPixel);
        }
        return;
    }

    private void computeVertexSnaps(NodedSegmentString nodedSegmentString) {
        Coordinate[] coordinateArray = nodedSegmentString.getCoordinates();
        int n = 0;
        while (n < coordinateArray.length) {
            HotPixel hotPixel = new HotPixel(coordinateArray[n], this.scaleFactor, this.li);
            if (this.pointSnapper.snap(hotPixel, nodedSegmentString, n)) {
                nodedSegmentString.addIntersection(coordinateArray[n], n);
            }
            ++n;
        }
        return;
    }

    private List findInteriorIntersections(Collection collection, LineIntersector object) {
        object = new InteriorIntersectionFinderAdder((LineIntersector)object);
        this.noder.setSegmentIntersector((SegmentIntersector)object);
        this.noder.computeNodes(collection);
        return ((InteriorIntersectionFinderAdder)object).getInteriorIntersections();
    }

    private void snapRound(Collection collection, LineIntersector lineIntersector) {
        this.computeIntersectionSnaps(this.findInteriorIntersections(collection, lineIntersector));
        this.computeVertexSnaps(collection);
    }

    @Override
    public void computeNodes(Collection collection) {
        MCIndexNoder mCIndexNoder;
        this.nodedSegStrings = collection;
        this.noder = mCIndexNoder = new MCIndexNoder();
        this.pointSnapper = new MCIndexPointSnapper(mCIndexNoder.getIndex());
        this.snapRound(collection, this.li);
    }

    public void computeVertexSnaps(Collection object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.computeVertexSnaps((NodedSegmentString)object.next());
        }
        return;
    }

    @Override
    public Collection getNodedSubstrings() {
        return NodedSegmentString.getNodedSubstrings(this.nodedSegStrings);
    }
}

