/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation;

import com.vividsolutions.jts.algorithm.BoundaryNodeRule;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.operation.Counter;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class BoundaryOp {
    private BoundaryNodeRule bnRule;
    private Map endpointMap;
    private Geometry geom;
    private GeometryFactory geomFact;

    public BoundaryOp(Geometry geometry) {
        this(geometry, BoundaryNodeRule.MOD2_BOUNDARY_RULE);
    }

    public BoundaryOp(Geometry geometry, BoundaryNodeRule boundaryNodeRule) {
        this.geom = geometry;
        this.geomFact = geometry.getFactory();
        this.bnRule = boundaryNodeRule;
    }

    private void addEndpoint(Coordinate coordinate) {
        Counter counter;
        Counter counter2 = counter = (Counter)this.endpointMap.get(coordinate);
        if (counter == null) {
            counter2 = new Counter();
            this.endpointMap.put(coordinate, counter2);
        }
        ++counter2.count;
    }

    private Geometry boundaryLineString(LineString lineString) {
        if (this.geom.isEmpty()) {
            return this.getEmptyMultiPoint();
        }
        if (lineString.isClosed()) {
            if (this.bnRule.isInBoundary(2)) {
                return lineString.getStartPoint();
            }
            return this.geomFact.createMultiPoint((Coordinate[])null);
        }
        return this.geomFact.createMultiPoint(new Point[]{lineString.getStartPoint(), lineString.getEndPoint()});
    }

    private Geometry boundaryMultiLineString(MultiLineString coordinateArray) {
        if (this.geom.isEmpty()) {
            return this.getEmptyMultiPoint();
        }
        if ((coordinateArray = this.computeBoundaryCoordinates((MultiLineString)coordinateArray)).length == 1) {
            return this.geomFact.createPoint(coordinateArray[0]);
        }
        return this.geomFact.createMultiPoint(coordinateArray);
    }

    private Coordinate[] computeBoundaryCoordinates(MultiLineString object) {
        ArrayList arrayList = new ArrayList();
        this.endpointMap = new TreeMap();
        int n = 0;
        while (true) {
            Object object2;
            if (n >= ((GeometryCollection)object).getNumGeometries()) {
                object2 = this.endpointMap.entrySet().iterator();
                while (true) {
                    if (!object2.hasNext()) {
                        return CoordinateArrays.toCoordinateArray(arrayList);
                    }
                    object = (Map.Entry)object2.next();
                    n = ((Counter)object.getValue()).count;
                    if (!this.bnRule.isInBoundary(n)) continue;
                    arrayList.add(object.getKey());
                }
            }
            object2 = (LineString)((GeometryCollection)object).getGeometryN(n);
            if (((LineString)object2).getNumPoints() != 0) {
                this.addEndpoint(((LineString)object2).getCoordinateN(0));
                this.addEndpoint(((LineString)object2).getCoordinateN(((LineString)object2).getNumPoints() - 1));
            }
            ++n;
        }
    }

    public static Geometry getBoundary(Geometry geometry) {
        return new BoundaryOp(geometry).getBoundary();
    }

    public static Geometry getBoundary(Geometry geometry, BoundaryNodeRule boundaryNodeRule) {
        return new BoundaryOp(geometry, boundaryNodeRule).getBoundary();
    }

    private MultiPoint getEmptyMultiPoint() {
        return this.geomFact.createMultiPoint((CoordinateSequence)null);
    }

    public Geometry getBoundary() {
        Geometry geometry = this.geom;
        if (geometry instanceof LineString) {
            return this.boundaryLineString((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.boundaryMultiLineString((MultiLineString)geometry);
        }
        return geometry.getBoundary();
    }
}

