/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;

public class BufferInputLineSimplifier {
    private static final int DELETE = 1;
    private static final int INIT = 0;
    private static final int KEEP = 1;
    private static final int NUM_PTS_TO_CHECK = 10;
    private int angleOrientation = 1;
    private double distanceTol;
    private Coordinate[] inputLine;
    private byte[] isDeleted;

    public BufferInputLineSimplifier(Coordinate[] coordinateArray) {
        this.inputLine = coordinateArray;
    }

    private Coordinate[] collapseLine() {
        CoordinateList coordinateList = new CoordinateList();
        int n = 0;
        Coordinate[] coordinateArray;
        while (n < (coordinateArray = this.inputLine).length) {
            if (this.isDeleted[n] != 1) {
                coordinateList.add(coordinateArray[n]);
            }
            ++n;
        }
        return coordinateList.toCoordinateArray();
    }

    private boolean deleteShallowConcavities() {
        int n = this.inputLine.length;
        int n2 = this.findNextNonDeletedIndex(1);
        n = this.findNextNonDeletedIndex(n2);
        int n3 = 1;
        boolean bl = false;
        while (n < this.inputLine.length) {
            if (this.isDeletable(n3, n2, n, this.distanceTol)) {
                this.isDeleted[n2] = (byte)1;
                n3 = 1;
                bl = true;
            } else {
                n3 = 0;
            }
            n3 = n3 != 0 ? n : n2;
            n2 = this.findNextNonDeletedIndex(n3);
            n = this.findNextNonDeletedIndex(n2);
        }
        return bl;
    }

    private int findNextNonDeletedIndex(int n) {
        ++n;
        while (n < this.inputLine.length && this.isDeleted[n] == 1) {
            ++n;
        }
        return n;
    }

    private boolean isConcave(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        boolean bl = CGAlgorithms.computeOrientation(coordinate, coordinate2, coordinate3) == this.angleOrientation;
        return bl;
    }

    private boolean isDeletable(int n, int n2, int n3, double d) {
        Object object = this.inputLine;
        Coordinate coordinate = object[n];
        Coordinate coordinate2 = object[n2];
        if (!this.isConcave(coordinate, coordinate2, (Coordinate)(object = object[n3]))) {
            return false;
        }
        if (!this.isShallow(coordinate, coordinate2, (Coordinate)object, d)) {
            return false;
        }
        return this.isShallowSampled(coordinate, coordinate2, n, n3, d);
    }

    private boolean isShallow(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, double d) {
        return CGAlgorithms.distancePointLine(coordinate2, coordinate, coordinate3) < d;
    }

    private boolean isShallowConcavity(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, double d) {
        boolean bl = CGAlgorithms.computeOrientation(coordinate, coordinate2, coordinate3) == this.angleOrientation;
        if (!bl) {
            return false;
        }
        return CGAlgorithms.distancePointLine(coordinate2, coordinate, coordinate3) < d;
    }

    private boolean isShallowSampled(Coordinate coordinate, Coordinate coordinate2, int n, int n2, double d) {
        int n3;
        int n4 = n3 = (n2 - n) / 10;
        int n5 = n;
        if (n3 <= 0) {
            n4 = 1;
            n5 = n;
        }
        while (n5 < n2) {
            if (!this.isShallow(coordinate, coordinate2, this.inputLine[n5], d)) {
                return false;
            }
            n5 += n4;
        }
        return true;
    }

    public static Coordinate[] simplify(Coordinate[] coordinateArray, double d) {
        return new BufferInputLineSimplifier(coordinateArray).simplify(d);
    }

    public Coordinate[] simplify(double d) {
        this.distanceTol = Math.abs(d);
        if (d < 0.0) {
            this.angleOrientation = -1;
        }
        this.isDeleted = new byte[this.inputLine.length];
        while (this.deleteShallowConcavities()) {
        }
        return this.collapseLine();
    }
}

