/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.math.MathUtil;
import com.vividsolutions.jts.noding.ScaledNoder;
import com.vividsolutions.jts.noding.snapround.MCIndexSnapRounder;
import com.vividsolutions.jts.operation.buffer.BufferBuilder;
import com.vividsolutions.jts.operation.buffer.BufferParameters;

public class BufferOp {
    public static final int CAP_BUTT = 2;
    public static final int CAP_FLAT = 2;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 3;
    private static int MAX_PRECISION_DIGITS = 12;
    private Geometry argGeom;
    private BufferParameters bufParams = new BufferParameters();
    private double distance;
    private Geometry resultGeometry = null;
    private RuntimeException saveException;

    public BufferOp(Geometry geometry) {
        this.argGeom = geometry;
    }

    public BufferOp(Geometry geometry, BufferParameters bufferParameters) {
        this.argGeom = geometry;
        this.bufParams = bufferParameters;
    }

    private void bufferFixedPrecision(PrecisionModel precisionModel) {
        ScaledNoder scaledNoder = new ScaledNoder(new MCIndexSnapRounder(new PrecisionModel(1.0)), precisionModel.getScale());
        BufferBuilder bufferBuilder = new BufferBuilder(this.bufParams);
        bufferBuilder.setWorkingPrecisionModel(precisionModel);
        bufferBuilder.setNoder(scaledNoder);
        this.resultGeometry = bufferBuilder.buffer(this.argGeom, this.distance);
    }

    public static Geometry bufferOp(Geometry geometry, double d) {
        return new BufferOp(geometry).getResultGeometry(d);
    }

    public static Geometry bufferOp(Geometry object, double d, int n) {
        object = new BufferOp((Geometry)object);
        ((BufferOp)object).setQuadrantSegments(n);
        return ((BufferOp)object).getResultGeometry(d);
    }

    public static Geometry bufferOp(Geometry object, double d, int n, int n2) {
        object = new BufferOp((Geometry)object);
        ((BufferOp)object).setQuadrantSegments(n);
        ((BufferOp)object).setEndCapStyle(n2);
        return ((BufferOp)object).getResultGeometry(d);
    }

    public static Geometry bufferOp(Geometry geometry, double d, BufferParameters bufferParameters) {
        return new BufferOp(geometry, bufferParameters).getResultGeometry(d);
    }

    private void bufferOriginalPrecision() {
        try {
            BufferBuilder bufferBuilder = new BufferBuilder(this.bufParams);
            this.resultGeometry = bufferBuilder.buffer(this.argGeom, this.distance);
        }
        catch (RuntimeException runtimeException) {
            this.saveException = runtimeException;
        }
    }

    private void bufferReducedPrecision() {
        for (int i = MAX_PRECISION_DIGITS; i >= 0; --i) {
            try {
                this.bufferReducedPrecision(i);
            }
            catch (TopologyException topologyException) {
                this.saveException = topologyException;
            }
            if (this.resultGeometry == null) continue;
            return;
        }
        throw this.saveException;
    }

    private void bufferReducedPrecision(int n) {
        this.bufferFixedPrecision(new PrecisionModel(BufferOp.precisionScaleFactor(this.argGeom, this.distance, n)));
    }

    private void computeGeometry() {
        this.bufferOriginalPrecision();
        if (this.resultGeometry != null) {
            return;
        }
        PrecisionModel precisionModel = this.argGeom.getFactory().getPrecisionModel();
        if (precisionModel.getType() == PrecisionModel.FIXED) {
            this.bufferFixedPrecision(precisionModel);
        } else {
            this.bufferReducedPrecision();
        }
    }

    private static double precisionScaleFactor(Geometry comparable, double d, int n) {
        comparable = ((Geometry)comparable).getEnvelopeInternal();
        double d2 = MathUtil.max(Math.abs(((Envelope)comparable).getMaxX()), Math.abs(((Envelope)comparable).getMaxY()), Math.abs(((Envelope)comparable).getMinX()), Math.abs(((Envelope)comparable).getMinY()));
        if (!(d > 0.0)) {
            d = 0.0;
        }
        return Math.pow(10.0, n - (int)(Math.log(d2 + d * 2.0) / Math.log(10.0) + 1.0));
    }

    public Geometry getResultGeometry(double d) {
        this.distance = d;
        this.computeGeometry();
        return this.resultGeometry;
    }

    public void setEndCapStyle(int n) {
        this.bufParams.setEndCapStyle(n);
    }

    public void setQuadrantSegments(int n) {
        this.bufParams.setQuadrantSegments(n);
    }
}

