/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

public class BufferParameters {
    public static final int CAP_FLAT = 2;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 3;
    public static final double DEFAULT_MITRE_LIMIT = 5.0;
    public static final int DEFAULT_QUADRANT_SEGMENTS = 8;
    public static final double DEFAULT_SIMPLIFY_FACTOR = 0.01;
    public static final int JOIN_BEVEL = 3;
    public static final int JOIN_MITRE = 2;
    public static final int JOIN_ROUND = 1;
    private int endCapStyle = 1;
    private boolean isSingleSided = false;
    private int joinStyle = 1;
    private double mitreLimit = 5.0;
    private int quadrantSegments = 8;
    private double simplifyFactor = 0.01;

    public BufferParameters() {
    }

    public BufferParameters(int n) {
        this.setQuadrantSegments(n);
    }

    public BufferParameters(int n, int n2) {
        this.setQuadrantSegments(n);
        this.setEndCapStyle(n2);
    }

    public BufferParameters(int n, int n2, int n3, double d) {
        this.setQuadrantSegments(n);
        this.setEndCapStyle(n2);
        this.setJoinStyle(n3);
        this.setMitreLimit(d);
    }

    public static double bufferDistanceError(int n) {
        return 1.0 - Math.cos(1.5707963267948966 / (double)n / 2.0);
    }

    public int getEndCapStyle() {
        return this.endCapStyle;
    }

    public int getJoinStyle() {
        return this.joinStyle;
    }

    public double getMitreLimit() {
        return this.mitreLimit;
    }

    public int getQuadrantSegments() {
        return this.quadrantSegments;
    }

    public double getSimplifyFactor() {
        return this.simplifyFactor;
    }

    public boolean isSingleSided() {
        return this.isSingleSided;
    }

    public void setEndCapStyle(int n) {
        this.endCapStyle = n;
    }

    public void setJoinStyle(int n) {
        this.joinStyle = n;
    }

    public void setMitreLimit(double d) {
        this.mitreLimit = d;
    }

    public void setQuadrantSegments(int n) {
        this.quadrantSegments = n;
        if (n == 0) {
            this.joinStyle = 3;
        }
        if (n < 0) {
            this.joinStyle = 2;
            this.mitreLimit = Math.abs(n);
        }
        if (n <= 0) {
            this.quadrantSegments = 1;
        }
        if (this.joinStyle != 1) {
            this.quadrantSegments = 8;
        }
    }

    public void setSimplifyFactor(double d) {
        double d2 = d;
        if (d < 0.0) {
            d2 = 0.0;
        }
        this.simplifyFactor = d2;
    }

    public void setSingleSided(boolean bl) {
        this.isSingleSided = bl;
    }
}

