/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.Angle;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.HCoordinate;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.NotRepresentableException;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import com.vividsolutions.jts.operation.buffer.OffsetSegmentString;

class OffsetSegmentGenerator {
    private static final double CURVE_VERTEX_SNAP_DISTANCE_FACTOR = 1.0E-6;
    private static final double INSIDE_TURN_VERTEX_SNAP_DISTANCE_FACTOR = 0.001;
    private static final int MAX_CLOSING_SEG_LEN_FACTOR = 80;
    private static final double OFFSET_SEGMENT_SEPARATION_FACTOR = 0.001;
    private BufferParameters bufParams;
    private int closingSegLengthFactor = 1;
    private double distance = 0.0;
    private double filletAngleQuantum;
    private boolean hasNarrowConcaveAngle = false;
    private LineIntersector li;
    private double maxCurveSegmentError = 0.0;
    private LineSegment offset0;
    private LineSegment offset1;
    private PrecisionModel precisionModel;
    private Coordinate s0;
    private Coordinate s1;
    private Coordinate s2;
    private LineSegment seg0 = new LineSegment();
    private LineSegment seg1 = new LineSegment();
    private OffsetSegmentString segList;
    private int side = 0;

    public OffsetSegmentGenerator(PrecisionModel precisionModel, BufferParameters bufferParameters, double d) {
        this.offset0 = new LineSegment();
        this.offset1 = new LineSegment();
        this.precisionModel = precisionModel;
        this.bufParams = bufferParameters;
        this.li = new RobustLineIntersector();
        this.filletAngleQuantum = 1.5707963267948966 / (double)bufferParameters.getQuadrantSegments();
        if (bufferParameters.getQuadrantSegments() >= 8 && bufferParameters.getJoinStyle() == 1) {
            this.closingSegLengthFactor = 80;
        }
        this.init(d);
    }

    private void addBevelJoin(LineSegment lineSegment, LineSegment lineSegment2) {
        this.segList.addPt(lineSegment.p1);
        this.segList.addPt(lineSegment2.p0);
    }

    private void addCollinear(boolean bl) {
        LineIntersector lineIntersector = this.li;
        Coordinate coordinate = this.s0;
        Coordinate coordinate2 = this.s1;
        lineIntersector.computeIntersection(coordinate, coordinate2, coordinate2, this.s2);
        if (this.li.getIntersectionNum() >= 2) {
            if (this.bufParams.getJoinStyle() != 3 && this.bufParams.getJoinStyle() != 2) {
                this.addFillet(this.s1, this.offset0.p1, this.offset1.p0, -1, this.distance);
            } else {
                if (bl) {
                    this.segList.addPt(this.offset0.p1);
                }
                this.segList.addPt(this.offset1.p0);
            }
        }
    }

    private void addFillet(Coordinate coordinate, double d, double d2, int n, double d3) {
        int n2 = -1;
        n = n == -1 ? n2 : 1;
        double d4 = Math.abs(d - d2);
        n2 = (int)(d4 / this.filletAngleQuantum + 0.5);
        if (n2 < 1) {
            return;
        }
        d2 = 0.0;
        double d5 = d4 / (double)n2;
        Coordinate coordinate2 = new Coordinate();
        while (d2 < d4) {
            double d6 = d + (double)n * d2;
            coordinate2.x = coordinate.x + Math.cos(d6) * d3;
            coordinate2.y = coordinate.y + Math.sin(d6) * d3;
            this.segList.addPt(coordinate2);
            d2 += d5;
        }
        return;
    }

    private void addFillet(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, int n, double d) {
        double d2 = coordinate2.x;
        double d3 = coordinate.x;
        d2 = Math.atan2(coordinate2.y - coordinate.y, d2 - d3);
        double d4 = coordinate3.x;
        d3 = coordinate.x;
        d4 = Math.atan2(coordinate3.y - coordinate.y, d4 - d3);
        if (n == -1) {
            d3 = d2;
            if (d2 <= d4) {
                d3 = d2 + Math.PI * 2;
            }
        } else {
            d3 = d2;
            if (d2 >= d4) {
                d3 = d2 - Math.PI * 2;
            }
        }
        this.segList.addPt(coordinate2);
        this.addFillet(coordinate, d3, d4, n, d);
        this.segList.addPt(coordinate3);
    }

    private void addInsideTurn(int n, boolean bl) {
        this.li.computeIntersection(this.offset0.p0, this.offset0.p1, this.offset1.p0, this.offset1.p1);
        if (this.li.hasIntersection()) {
            this.segList.addPt(this.li.getIntersection(0));
        } else {
            this.hasNarrowConcaveAngle = true;
            if (this.offset0.p1.distance(this.offset1.p0) < this.distance * 0.001) {
                this.segList.addPt(this.offset0.p1);
            } else {
                this.segList.addPt(this.offset0.p1);
                n = this.closingSegLengthFactor;
                if (n > 0) {
                    double d = n;
                    double d2 = this.offset0.p1.x;
                    double d3 = this.s1.x;
                    n = this.closingSegLengthFactor;
                    Coordinate coordinate = new Coordinate((d * d2 + d3) / (double)(n + 1), ((double)n * this.offset0.p1.y + this.s1.y) / (double)(this.closingSegLengthFactor + 1));
                    this.segList.addPt(coordinate);
                    d2 = this.closingSegLengthFactor;
                    d3 = this.offset1.p0.x;
                    d = this.s1.x;
                    n = this.closingSegLengthFactor;
                    coordinate = new Coordinate((d2 * d3 + d) / (double)(n + 1), ((double)n * this.offset1.p0.y + this.s1.y) / (double)(this.closingSegLengthFactor + 1));
                    this.segList.addPt(coordinate);
                } else {
                    this.segList.addPt(this.s1);
                }
                this.segList.addPt(this.offset1.p0);
            }
        }
    }

    private void addLimitedMitreJoin(LineSegment comparable, LineSegment comparable2, double d, double d2) {
        comparable = this.seg0.p1;
        double d3 = Angle.angle((Coordinate)comparable, this.seg0.p0);
        Angle.angle((Coordinate)comparable, this.seg1.p1);
        double d4 = Angle.angleBetweenOriented(this.seg0.p0, (Coordinate)comparable, this.seg1.p1) / 2.0;
        d3 = Angle.normalize(Angle.normalize(d3 + d4) + Math.PI);
        d2 *= d;
        comparable2 = new LineSegment((Coordinate)comparable, new Coordinate(((Coordinate)comparable).x + Math.cos(d3) * d2, ((Coordinate)comparable).y + d2 * Math.sin(d3)));
        comparable = comparable2.pointAlongOffset(1.0, d -= Math.abs(Math.sin(d4)) * d2);
        comparable2 = comparable2.pointAlongOffset(1.0, -d);
        if (this.side == 1) {
            this.segList.addPt((Coordinate)comparable);
            this.segList.addPt((Coordinate)comparable2);
        } else {
            this.segList.addPt((Coordinate)comparable2);
            this.segList.addPt((Coordinate)comparable);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addMitreJoin(Coordinate coordinate, LineSegment lineSegment, LineSegment lineSegment2, double d) {
        boolean bl;
        block6: {
            double d2;
            Coordinate coordinate2;
            bl = false;
            try {
                coordinate2 = HCoordinate.intersection(lineSegment.p0, lineSegment.p1, lineSegment2.p0, lineSegment2.p1);
            }
            catch (NotRepresentableException notRepresentableException) {
                coordinate = new Coordinate(0.0, 0.0);
                break block6;
            }
            double d3 = d <= 0.0 ? 1.0 : coordinate2.distance(coordinate) / Math.abs(d);
            {
                d2 = this.bufParams.getMitreLimit();
            }
            if (d3 > d2) {
                coordinate = coordinate2;
            } else {
                bl = true;
                coordinate = coordinate2;
            }
        }
        if (bl) {
            this.segList.addPt(coordinate);
            return;
        }
        this.addLimitedMitreJoin(lineSegment, lineSegment2, d, this.bufParams.getMitreLimit());
    }

    private void addOutsideTurn(int n, boolean bl) {
        if (this.offset0.p1.distance(this.offset1.p0) < this.distance * 0.001) {
            this.segList.addPt(this.offset0.p1);
            return;
        }
        if (this.bufParams.getJoinStyle() == 2) {
            this.addMitreJoin(this.s1, this.offset0, this.offset1, this.distance);
        } else if (this.bufParams.getJoinStyle() == 3) {
            this.addBevelJoin(this.offset0, this.offset1);
        } else {
            if (bl) {
                this.segList.addPt(this.offset0.p1);
            }
            this.addFillet(this.s1, this.offset0.p1, this.offset1.p0, n, this.distance);
            this.segList.addPt(this.offset1.p0);
        }
    }

    private void computeOffsetSegment(LineSegment lineSegment, int n, double d, LineSegment lineSegment2) {
        int n2 = 1;
        n = n == 1 ? n2 : -1;
        double d2 = lineSegment.p1.x - lineSegment.p0.x;
        double d3 = lineSegment.p1.y - lineSegment.p0.y;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = (double)n * d;
        d = d2 * d5 / d4;
        d4 = d5 * d3 / d4;
        lineSegment2.p0.x = lineSegment.p0.x - d4;
        lineSegment2.p0.y = lineSegment.p0.y + d;
        lineSegment2.p1.x = lineSegment.p1.x - d4;
        lineSegment2.p1.y = lineSegment.p1.y + d;
    }

    private void init(double d) {
        OffsetSegmentString offsetSegmentString;
        this.distance = d;
        this.maxCurveSegmentError = (1.0 - Math.cos(this.filletAngleQuantum / 2.0)) * d;
        this.segList = offsetSegmentString = new OffsetSegmentString();
        offsetSegmentString.setPrecisionModel(this.precisionModel);
        this.segList.setMinimumVertexDistance(d * 1.0E-6);
    }

    public void addFirstSegment() {
        this.segList.addPt(this.offset1.p0);
    }

    public void addLastSegment() {
        this.segList.addPt(this.offset1.p1);
    }

    public void addLineEndCap(Coordinate coordinate, Coordinate coordinate2) {
        LineSegment lineSegment = new LineSegment(coordinate, coordinate2);
        LineSegment lineSegment2 = new LineSegment();
        this.computeOffsetSegment(lineSegment, 1, this.distance, lineSegment2);
        LineSegment lineSegment3 = new LineSegment();
        this.computeOffsetSegment(lineSegment, 2, this.distance, lineSegment3);
        double d = coordinate2.x;
        double d2 = coordinate.x;
        d2 = Math.atan2(coordinate2.y - coordinate.y, d - d2);
        int n = this.bufParams.getEndCapStyle();
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    coordinate = new Coordinate();
                    coordinate.x = Math.abs(this.distance) * Math.cos(d2);
                    coordinate.y = Math.abs(this.distance) * Math.sin(d2);
                    coordinate2 = new Coordinate(lineSegment2.p1.x + coordinate.x, lineSegment2.p1.y + coordinate.y);
                    coordinate = new Coordinate(lineSegment3.p1.x + coordinate.x, lineSegment3.p1.y + coordinate.y);
                    this.segList.addPt(coordinate2);
                    this.segList.addPt(coordinate);
                }
            } else {
                this.segList.addPt(lineSegment2.p1);
                this.segList.addPt(lineSegment3.p1);
            }
        } else {
            this.segList.addPt(lineSegment2.p1);
            this.addFillet(coordinate2, d2 + 1.5707963267948966, d2 - 1.5707963267948966, -1, this.distance);
            this.segList.addPt(lineSegment3.p1);
        }
    }

    public void addNextSegment(Coordinate coordinate, boolean bl) {
        boolean bl2;
        int n;
        block9: {
            block10: {
                boolean bl3;
                block8: {
                    Coordinate coordinate2;
                    Coordinate coordinate3;
                    this.s0 = coordinate3 = this.s1;
                    this.s1 = coordinate2 = this.s2;
                    this.s2 = coordinate;
                    this.seg0.setCoordinates(coordinate3, coordinate2);
                    this.computeOffsetSegment(this.seg0, this.side, this.distance, this.offset0);
                    this.seg1.setCoordinates(this.s1, this.s2);
                    this.computeOffsetSegment(this.seg1, this.side, this.distance, this.offset1);
                    if (this.s1.equals(this.s2)) {
                        return;
                    }
                    n = CGAlgorithms.computeOrientation(this.s0, this.s1, this.s2);
                    bl3 = true;
                    if (n != -1) break block8;
                    bl2 = bl3;
                    if (this.side == 1) break block9;
                }
                if (n != 1) break block10;
                bl2 = bl3;
                if (this.side == 2) break block9;
            }
            bl2 = false;
        }
        if (n == 0) {
            this.addCollinear(bl);
        } else if (bl2) {
            this.addOutsideTurn(n, bl);
        } else {
            this.addInsideTurn(n, bl);
        }
    }

    public void addSegments(Coordinate[] coordinateArray, boolean bl) {
        this.segList.addPts(coordinateArray, bl);
    }

    public void closeRing() {
        this.segList.closeRing();
    }

    public void createCircle(Coordinate coordinate) {
        Coordinate coordinate2 = new Coordinate(coordinate.x + this.distance, coordinate.y);
        this.segList.addPt(coordinate2);
        this.addFillet(coordinate, 0.0, Math.PI * 2, -1, this.distance);
        this.segList.closeRing();
    }

    public void createSquare(Coordinate coordinate) {
        this.segList.addPt(new Coordinate(coordinate.x + this.distance, coordinate.y + this.distance));
        this.segList.addPt(new Coordinate(coordinate.x + this.distance, coordinate.y - this.distance));
        this.segList.addPt(new Coordinate(coordinate.x - this.distance, coordinate.y - this.distance));
        this.segList.addPt(new Coordinate(coordinate.x - this.distance, coordinate.y + this.distance));
        this.segList.closeRing();
    }

    public Coordinate[] getCoordinates() {
        return this.segList.getCoordinates();
    }

    public boolean hasNarrowConcaveAngle() {
        return this.hasNarrowConcaveAngle;
    }

    public void initSideSegments(Coordinate coordinate, Coordinate coordinate2, int n) {
        this.s1 = coordinate;
        this.s2 = coordinate2;
        this.side = n;
        this.seg1.setCoordinates(coordinate, coordinate2);
        this.computeOffsetSegment(this.seg1, n, this.distance, this.offset1);
    }
}

