/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.operation.buffer.BufferSubgraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class SubgraphDepthLocater {
    private CGAlgorithms cga;
    private LineSegment seg = new LineSegment();
    private Collection subgraphs;

    public SubgraphDepthLocater(List list) {
        this.cga = new CGAlgorithms();
        this.subgraphs = list;
    }

    private List findStabbedSegments(Coordinate coordinate) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator2 = this.subgraphs.iterator();
        while (iterator2.hasNext()) {
            BufferSubgraph bufferSubgraph = (BufferSubgraph)iterator2.next();
            Envelope envelope = bufferSubgraph.getEnvelope();
            if (coordinate.y < envelope.getMinY() || coordinate.y > envelope.getMaxY()) continue;
            this.findStabbedSegments(coordinate, bufferSubgraph.getDirectedEdges(), arrayList);
        }
        return arrayList;
    }

    private void findStabbedSegments(Coordinate coordinate, DirectedEdge directedEdge, List list) {
        Coordinate[] coordinateArray = directedEdge.getEdge().getCoordinates();
        int n = 0;
        while (n < coordinateArray.length - 1) {
            this.seg.p0 = coordinateArray[n];
            LineSegment lineSegment = this.seg;
            int n2 = n + 1;
            lineSegment.p1 = coordinateArray[n2];
            if (this.seg.p0.y > this.seg.p1.y) {
                this.seg.reverse();
            }
            if (!(Math.max(this.seg.p0.x, this.seg.p1.x) < coordinate.x || this.seg.isHorizontal() || coordinate.y < this.seg.p0.y || coordinate.y > this.seg.p1.y || CGAlgorithms.computeOrientation(this.seg.p0, this.seg.p1, coordinate) == -1)) {
                int n3 = directedEdge.getDepth(1);
                if (!this.seg.p0.equals(coordinateArray[n])) {
                    n3 = directedEdge.getDepth(2);
                }
                list.add(new DepthSegment(this.seg, n3));
            }
            n = n2;
        }
        return;
    }

    private void findStabbedSegments(Coordinate coordinate, List object, List list) {
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = (DirectedEdge)iterator2.next();
            if (!((DirectedEdge)object).isForward()) continue;
            this.findStabbedSegments(coordinate, (DirectedEdge)object, list);
        }
        return;
    }

    public int getDepth(Coordinate object) {
        if ((object = this.findStabbedSegments((Coordinate)object)).size() == 0) {
            return 0;
        }
        return ((DepthSegment)Collections.min(object)).leftDepth;
    }

    static class DepthSegment
    implements Comparable {
        private int leftDepth;
        private LineSegment upwardSeg;

        public DepthSegment(LineSegment lineSegment, int n) {
            this.upwardSeg = new LineSegment(lineSegment);
            this.leftDepth = n;
        }

        private int compareX(LineSegment lineSegment, LineSegment lineSegment2) {
            int n = lineSegment.p0.compareTo(lineSegment2.p0);
            if (n != 0) {
                return n;
            }
            return lineSegment.p1.compareTo(lineSegment2.p1);
        }

        public int compareTo(Object object) {
            object = (DepthSegment)object;
            if (this.upwardSeg.minX() >= ((DepthSegment)object).upwardSeg.maxX()) {
                return 1;
            }
            if (this.upwardSeg.maxX() <= ((DepthSegment)object).upwardSeg.minX()) {
                return -1;
            }
            int n = this.upwardSeg.orientationIndex(((DepthSegment)object).upwardSeg);
            if (n != 0) {
                return n;
            }
            n = ((DepthSegment)object).upwardSeg.orientationIndex(this.upwardSeg) * -1;
            if (n != 0) {
                return n;
            }
            return this.upwardSeg.compareTo(((DepthSegment)object).upwardSeg);
        }

        public String toString() {
            return this.upwardSeg.toString();
        }
    }
}

