/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer.validate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.buffer.validate.DistanceToPointFinder;
import com.vividsolutions.jts.operation.buffer.validate.PointPairDistance;

public class BufferCurveMaximumDistanceFinder {
    private Geometry inputGeom;
    private PointPairDistance maxPtDist = new PointPairDistance();

    public BufferCurveMaximumDistanceFinder(Geometry geometry) {
        this.inputGeom = geometry;
    }

    private void computeMaxMidpointDistance(Geometry geometry) {
        MaxMidpointDistanceFilter maxMidpointDistanceFilter = new MaxMidpointDistanceFilter(this.inputGeom);
        geometry.apply(maxMidpointDistanceFilter);
        this.maxPtDist.setMaximum(maxMidpointDistanceFilter.getMaxPointDistance());
    }

    private void computeMaxVertexDistance(Geometry geometry) {
        MaxPointDistanceFilter maxPointDistanceFilter = new MaxPointDistanceFilter(this.inputGeom);
        geometry.apply(maxPointDistanceFilter);
        this.maxPtDist.setMaximum(maxPointDistanceFilter.getMaxPointDistance());
    }

    public double findDistance(Geometry geometry) {
        this.computeMaxVertexDistance(geometry);
        this.computeMaxMidpointDistance(geometry);
        return this.maxPtDist.getDistance();
    }

    public PointPairDistance getDistancePoints() {
        return this.maxPtDist;
    }

    public static class MaxMidpointDistanceFilter
    implements CoordinateSequenceFilter {
        private Geometry geom;
        private PointPairDistance maxPtDist = new PointPairDistance();
        private PointPairDistance minPtDist = new PointPairDistance();

        public MaxMidpointDistanceFilter(Geometry geometry) {
            this.geom = geometry;
        }

        @Override
        public void filter(CoordinateSequence cloneable, int n) {
            if (n == 0) {
                return;
            }
            Coordinate coordinate = cloneable.getCoordinate(n - 1);
            cloneable = cloneable.getCoordinate(n);
            cloneable = new Coordinate((coordinate.x + ((Coordinate)cloneable).x) / 2.0, (coordinate.y + ((Coordinate)cloneable).y) / 2.0);
            this.minPtDist.initialize();
            DistanceToPointFinder.computeDistance(this.geom, (Coordinate)cloneable, this.minPtDist);
            this.maxPtDist.setMaximum(this.minPtDist);
        }

        public PointPairDistance getMaxPointDistance() {
            return this.maxPtDist;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public boolean isGeometryChanged() {
            return false;
        }
    }

    public static class MaxPointDistanceFilter
    implements CoordinateFilter {
        private Geometry geom;
        private PointPairDistance maxPtDist = new PointPairDistance();
        private PointPairDistance minPtDist = new PointPairDistance();

        public MaxPointDistanceFilter(Geometry geometry) {
            this.geom = geometry;
        }

        @Override
        public void filter(Coordinate coordinate) {
            this.minPtDist.initialize();
            DistanceToPointFinder.computeDistance(this.geom, coordinate, this.minPtDist);
            this.maxPtDist.setMaximum(this.minPtDist);
        }

        public PointPairDistance getMaxPointDistance() {
            return this.maxPtDist;
        }
    }
}

