/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer.validate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.buffer.validate.PointPairDistance;

public class DistanceToPointFinder {
    public static void computeDistance(Geometry geometry, Coordinate coordinate, PointPairDistance pointPairDistance) {
        if (geometry instanceof LineString) {
            DistanceToPointFinder.computeDistance((LineString)geometry, coordinate, pointPairDistance);
        } else if (geometry instanceof Polygon) {
            DistanceToPointFinder.computeDistance((Polygon)geometry, coordinate, pointPairDistance);
        } else if (geometry instanceof GeometryCollection) {
            geometry = (GeometryCollection)geometry;
            for (int i = 0; i < ((GeometryCollection)geometry).getNumGeometries(); ++i) {
                DistanceToPointFinder.computeDistance(((GeometryCollection)geometry).getGeometryN(i), coordinate, pointPairDistance);
            }
        } else {
            pointPairDistance.setMinimum(geometry.getCoordinate(), coordinate);
        }
    }

    public static void computeDistance(LineSegment lineSegment, Coordinate coordinate, PointPairDistance pointPairDistance) {
        pointPairDistance.setMinimum(lineSegment.closestPoint(coordinate), coordinate);
    }

    public static void computeDistance(LineString cloneable, Coordinate coordinate, PointPairDistance pointPairDistance) {
        Coordinate[] coordinateArray = cloneable.getCoordinates();
        LineSegment lineSegment = new LineSegment();
        int n = 0;
        while (n < coordinateArray.length - 1) {
            cloneable = coordinateArray[n];
            lineSegment.setCoordinates((Coordinate)cloneable, coordinateArray[++n]);
            pointPairDistance.setMinimum(lineSegment.closestPoint(coordinate), coordinate);
        }
        return;
    }

    public static void computeDistance(Polygon polygon, Coordinate coordinate, PointPairDistance pointPairDistance) {
        DistanceToPointFinder.computeDistance(polygon.getExteriorRing(), coordinate, pointPairDistance);
        int n = 0;
        while (n < polygon.getNumInteriorRing()) {
            DistanceToPointFinder.computeDistance(polygon.getInteriorRingN(n), coordinate, pointPairDistance);
            ++n;
        }
        return;
    }
}

