/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.distance;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.geom.util.PointExtracter;
import com.vividsolutions.jts.geom.util.PolygonExtracter;
import com.vividsolutions.jts.operation.distance.ConnectedElementLocationFilter;
import com.vividsolutions.jts.operation.distance.GeometryLocation;
import java.util.List;

public class DistanceOp {
    private Geometry[] geom;
    private double minDistance;
    private GeometryLocation[] minDistanceLocation;
    private PointLocator ptLocator = new PointLocator();
    private double terminateDistance = 0.0;

    public DistanceOp(Geometry geometry, Geometry geometry2) {
        this(geometry, geometry2, 0.0);
    }

    public DistanceOp(Geometry geometry, Geometry geometry2, double d) {
        this.minDistance = Double.MAX_VALUE;
        Geometry[] geometryArray = new Geometry[2];
        this.geom = geometryArray;
        geometryArray[0] = geometry;
        geometryArray[1] = geometry2;
        this.terminateDistance = d;
    }

    public static Coordinate[] closestPoints(Geometry geometry, Geometry geometry2) {
        return new DistanceOp(geometry, geometry2).nearestPoints();
    }

    private void computeContainmentDistance() {
        GeometryLocation[] geometryLocationArray = new GeometryLocation[2];
        this.computeContainmentDistance(0, geometryLocationArray);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        this.computeContainmentDistance(1, geometryLocationArray);
    }

    private void computeContainmentDistance(int n, GeometryLocation[] geometryLocationArray) {
        int n2 = 1 - n;
        GeometryLocation[] geometryLocationArray2 = PolygonExtracter.getPolygons(this.geom[n]);
        if (geometryLocationArray2.size() > 0) {
            this.computeContainmentDistance(ConnectedElementLocationFilter.getLocations(this.geom[n2]), (List)geometryLocationArray2, geometryLocationArray);
            if (this.minDistance <= this.terminateDistance) {
                geometryLocationArray2 = this.minDistanceLocation;
                geometryLocationArray2[n2] = geometryLocationArray[0];
                geometryLocationArray2[n] = geometryLocationArray[1];
            }
        }
    }

    private void computeContainmentDistance(GeometryLocation geometryLocation, Polygon polygon, GeometryLocation[] geometryLocationArray) {
        Coordinate coordinate = geometryLocation.getCoordinate();
        if (2 != this.ptLocator.locate(coordinate, (Geometry)polygon)) {
            this.minDistance = 0.0;
            geometryLocationArray[0] = geometryLocation;
            geometryLocationArray[1] = new GeometryLocation(polygon, coordinate);
        }
    }

    private void computeContainmentDistance(List list, List list2, GeometryLocation[] geometryLocationArray) {
        int n = 0;
        block0: while (n < list.size()) {
            GeometryLocation geometryLocation = (GeometryLocation)list.get(n);
            int n2 = 0;
            while (true) {
                if (n2 >= list2.size()) {
                    ++n;
                    continue block0;
                }
                this.computeContainmentDistance(geometryLocation, (Polygon)list2.get(n2), geometryLocationArray);
                if (this.minDistance <= this.terminateDistance) {
                    return;
                }
                ++n2;
            }
            break;
        }
        return;
    }

    private void computeFacetDistance() {
        GeometryLocation[] geometryLocationArray = new GeometryLocation[2];
        List list = LinearComponentExtracter.getLines(this.geom[0]);
        List list2 = LinearComponentExtracter.getLines(this.geom[1]);
        List list3 = PointExtracter.getPoints(this.geom[0]);
        List list4 = PointExtracter.getPoints(this.geom[1]);
        this.computeMinDistanceLines(list, list2, geometryLocationArray);
        this.updateMinDistance(geometryLocationArray, false);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        geometryLocationArray[0] = null;
        geometryLocationArray[1] = null;
        this.computeMinDistanceLinesPoints(list, list4, geometryLocationArray);
        this.updateMinDistance(geometryLocationArray, false);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        geometryLocationArray[0] = null;
        geometryLocationArray[1] = null;
        this.computeMinDistanceLinesPoints(list2, list3, geometryLocationArray);
        this.updateMinDistance(geometryLocationArray, true);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        geometryLocationArray[0] = null;
        geometryLocationArray[1] = null;
        this.computeMinDistancePoints(list3, list4, geometryLocationArray);
        this.updateMinDistance(geometryLocationArray, false);
    }

    private void computeMinDistance() {
        if (this.minDistanceLocation != null) {
            return;
        }
        this.minDistanceLocation = new GeometryLocation[2];
        this.computeContainmentDistance();
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        this.computeFacetDistance();
    }

    private void computeMinDistance(LineString lineString, LineString lineString2, GeometryLocation[] geometryLocationArray) {
        if (lineString.getEnvelopeInternal().distance(lineString2.getEnvelopeInternal()) > this.minDistance) {
            return;
        }
        Coordinate[] coordinateArray = lineString.getCoordinates();
        Coordinate[] coordinateArray2 = lineString2.getCoordinates();
        int n = 0;
        block0: while (n < coordinateArray.length - 1) {
            int n2 = 0;
            while (true) {
                if (n2 >= coordinateArray2.length - 1) {
                    ++n;
                    continue block0;
                }
                Coordinate coordinate = coordinateArray[n];
                int n3 = n + 1;
                Coordinate coordinate2 = coordinateArray[n3];
                Coordinate[] coordinateArray3 = coordinateArray2[n2];
                int n4 = n2 + 1;
                double d = CGAlgorithms.distanceLineLine(coordinate, coordinate2, (Coordinate)coordinateArray3, coordinateArray2[n4]);
                if (d < this.minDistance) {
                    this.minDistance = d;
                    coordinateArray3 = new LineSegment(coordinateArray[n], coordinateArray[n3]).closestPoints(new LineSegment(coordinateArray2[n2], coordinateArray2[n4]));
                    geometryLocationArray[0] = new GeometryLocation(lineString, n, coordinateArray3[0]);
                    geometryLocationArray[1] = new GeometryLocation(lineString2, n2, coordinateArray3[1]);
                }
                if (this.minDistance <= this.terminateDistance) {
                    return;
                }
                n2 = n4;
            }
            break;
        }
        return;
    }

    private void computeMinDistance(LineString lineString, Point point, GeometryLocation[] geometryLocationArray) {
        if (lineString.getEnvelopeInternal().distance(point.getEnvelopeInternal()) > this.minDistance) {
            return;
        }
        Coordinate[] coordinateArray = lineString.getCoordinates();
        Coordinate coordinate = point.getCoordinate();
        int n = 0;
        while (n < coordinateArray.length - 1) {
            Coordinate coordinate2 = coordinateArray[n];
            int n2 = n + 1;
            double d = CGAlgorithms.distancePointLine(coordinate, coordinate2, coordinateArray[n2]);
            if (d < this.minDistance) {
                this.minDistance = d;
                geometryLocationArray[0] = new GeometryLocation(lineString, n, new LineSegment(coordinateArray[n], coordinateArray[n2]).closestPoint(coordinate));
                geometryLocationArray[1] = new GeometryLocation(point, 0, coordinate);
            }
            if (this.minDistance <= this.terminateDistance) {
                return;
            }
            n = n2;
        }
        return;
    }

    private void computeMinDistanceLines(List list, List list2, GeometryLocation[] geometryLocationArray) {
        int n = 0;
        block0: while (n < list.size()) {
            LineString lineString = (LineString)list.get(n);
            int n2 = 0;
            while (true) {
                if (n2 >= list2.size()) {
                    ++n;
                    continue block0;
                }
                this.computeMinDistance(lineString, (LineString)list2.get(n2), geometryLocationArray);
                if (this.minDistance <= this.terminateDistance) {
                    return;
                }
                ++n2;
            }
            break;
        }
        return;
    }

    private void computeMinDistanceLinesPoints(List list, List list2, GeometryLocation[] geometryLocationArray) {
        int n = 0;
        block0: while (n < list.size()) {
            LineString lineString = (LineString)list.get(n);
            int n2 = 0;
            while (true) {
                if (n2 >= list2.size()) {
                    ++n;
                    continue block0;
                }
                this.computeMinDistance(lineString, (Point)list2.get(n2), geometryLocationArray);
                if (this.minDistance <= this.terminateDistance) {
                    return;
                }
                ++n2;
            }
            break;
        }
        return;
    }

    private void computeMinDistancePoints(List list, List list2, GeometryLocation[] geometryLocationArray) {
        int n = 0;
        block0: while (n < list.size()) {
            Point point = (Point)list.get(n);
            int n2 = 0;
            while (true) {
                if (n2 >= list2.size()) {
                    ++n;
                    continue block0;
                }
                Point point2 = (Point)list2.get(n2);
                double d = point.getCoordinate().distance(point2.getCoordinate());
                if (d < this.minDistance) {
                    this.minDistance = d;
                    geometryLocationArray[0] = new GeometryLocation(point, 0, point.getCoordinate());
                    geometryLocationArray[1] = new GeometryLocation(point2, 0, point2.getCoordinate());
                }
                if (this.minDistance <= this.terminateDistance) {
                    return;
                }
                ++n2;
            }
            break;
        }
        return;
    }

    public static double distance(Geometry geometry, Geometry geometry2) {
        return new DistanceOp(geometry, geometry2).distance();
    }

    public static boolean isWithinDistance(Geometry geometry, Geometry geometry2, double d) {
        return new DistanceOp(geometry, geometry2, d).distance() <= d;
    }

    public static Coordinate[] nearestPoints(Geometry geometry, Geometry geometry2) {
        return new DistanceOp(geometry, geometry2).nearestPoints();
    }

    private void updateMinDistance(GeometryLocation[] geometryLocationArray, boolean bl) {
        if (geometryLocationArray[0] == null) {
            return;
        }
        if (bl) {
            GeometryLocation[] geometryLocationArray2 = this.minDistanceLocation;
            geometryLocationArray2[0] = geometryLocationArray[1];
            geometryLocationArray2[1] = geometryLocationArray[0];
        } else {
            GeometryLocation[] geometryLocationArray3 = this.minDistanceLocation;
            geometryLocationArray3[0] = geometryLocationArray[0];
            geometryLocationArray3[1] = geometryLocationArray[1];
        }
    }

    public GeometryLocation[] closestLocations() {
        return this.nearestLocations();
    }

    public Coordinate[] closestPoints() {
        return this.nearestPoints();
    }

    public double distance() {
        Geometry[] geometryArray = this.geom;
        if (geometryArray[0] != null && geometryArray[1] != null) {
            if (!geometryArray[0].isEmpty() && !this.geom[1].isEmpty()) {
                this.computeMinDistance();
                return this.minDistance;
            }
            return 0.0;
        }
        throw new IllegalArgumentException("null geometries are not supported");
    }

    public GeometryLocation[] nearestLocations() {
        this.computeMinDistance();
        return this.minDistanceLocation;
    }

    public Coordinate[] nearestPoints() {
        this.computeMinDistance();
        return new Coordinate[]{this.minDistanceLocation[0].getCoordinate(), this.minDistanceLocation[1].getCoordinate()};
    }
}

