/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.distance;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;

public class FacetSequence {
    private int end;
    private Coordinate p0;
    private Coordinate p1;
    private Coordinate pt = new Coordinate();
    private CoordinateSequence pts;
    private Coordinate q0;
    private Coordinate q1;
    private Coordinate seqPt = new Coordinate();
    private int start;

    public FacetSequence(CoordinateSequence coordinateSequence, int n) {
        this.p0 = new Coordinate();
        this.p1 = new Coordinate();
        this.q0 = new Coordinate();
        this.q1 = new Coordinate();
        this.pts = coordinateSequence;
        this.start = n;
        this.end = n + 1;
    }

    public FacetSequence(CoordinateSequence coordinateSequence, int n, int n2) {
        this.p0 = new Coordinate();
        this.p1 = new Coordinate();
        this.q0 = new Coordinate();
        this.q1 = new Coordinate();
        this.pts = coordinateSequence;
        this.start = n;
        this.end = n2;
    }

    private double computeLineLineDistance(FacetSequence facetSequence) {
        int n = this.start;
        double d = Double.MAX_VALUE;
        block0: while (n < this.end - 1) {
            int n2 = facetSequence.start;
            while (true) {
                if (n2 >= facetSequence.end - 1) {
                    ++n;
                    continue block0;
                }
                this.pts.getCoordinate(n, this.p0);
                this.pts.getCoordinate(n + 1, this.p1);
                facetSequence.pts.getCoordinate(n2, this.q0);
                CoordinateSequence coordinateSequence = facetSequence.pts;
                int n3 = n2 + 1;
                coordinateSequence.getCoordinate(n3, this.q1);
                double d2 = CGAlgorithms.distanceLineLine(this.p0, this.p1, this.q0, this.q1);
                if (d2 == 0.0) {
                    return 0.0;
                }
                n2 = n3;
                if (!(d2 < d)) continue;
                d = d2;
                n2 = n3;
            }
            break;
        }
        return d;
    }

    private double computePointLineDistance(Coordinate coordinate, FacetSequence facetSequence) {
        int n = facetSequence.start;
        double d = Double.MAX_VALUE;
        while (n < facetSequence.end - 1) {
            facetSequence.pts.getCoordinate(n, this.q0);
            CoordinateSequence coordinateSequence = facetSequence.pts;
            int n2 = n + 1;
            coordinateSequence.getCoordinate(n2, this.q1);
            double d2 = CGAlgorithms.distancePointLine(coordinate, this.q0, this.q1);
            if (d2 == 0.0) {
                return 0.0;
            }
            n = n2;
            if (!(d2 < d)) continue;
            d = d2;
            n = n2;
        }
        return d;
    }

    public double distance(FacetSequence facetSequence) {
        boolean bl = this.isPoint();
        boolean bl2 = facetSequence.isPoint();
        if (bl && bl2) {
            this.pts.getCoordinate(this.start, this.pt);
            facetSequence.pts.getCoordinate(facetSequence.start, this.seqPt);
            return this.pt.distance(this.seqPt);
        }
        if (bl) {
            this.pts.getCoordinate(this.start, this.pt);
            return this.computePointLineDistance(this.pt, facetSequence);
        }
        if (bl2) {
            facetSequence.pts.getCoordinate(facetSequence.start, this.seqPt);
            return this.computePointLineDistance(this.seqPt, this);
        }
        return this.computeLineLineDistance(facetSequence);
    }

    public Coordinate getCoordinate(int n) {
        return this.pts.getCoordinate(this.start + n);
    }

    public Envelope getEnvelope() {
        Envelope envelope = new Envelope();
        int n = this.start;
        while (n < this.end) {
            envelope.expandToInclude(this.pts.getX(n), this.pts.getY(n));
            ++n;
        }
        return envelope;
    }

    public boolean isPoint() {
        return this.end - this.start == 1;
    }

    public int size() {
        return this.end - this.start;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LINESTRING ( ");
        Coordinate coordinate = new Coordinate();
        int n = this.start;
        while (true) {
            if (n >= this.end) {
                stringBuffer.append(" )");
                return stringBuffer.toString();
            }
            if (n > this.start) {
                stringBuffer.append(", ");
            }
            this.pts.getCoordinate(n, coordinate);
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(coordinate.x));
            stringBuilder.append(" ");
            stringBuilder.append(coordinate.y);
            stringBuffer.append(stringBuilder.toString());
            ++n;
        }
    }
}

