/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.distance3d;

import com.vividsolutions.jts.algorithm.CGAlgorithms3D;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.distance.GeometryLocation;
import com.vividsolutions.jts.operation.distance3d.PlanarPolygon3D;

public class Distance3DOp {
    private Geometry[] geom;
    private boolean isDone = false;
    private double minDistance = Double.MAX_VALUE;
    private GeometryLocation[] minDistanceLocation;
    private double terminateDistance = 0.0;

    public Distance3DOp(Geometry geometry, Geometry geometry2) {
        this(geometry, geometry2, 0.0);
    }

    public Distance3DOp(Geometry geometry, Geometry geometry2, double d) {
        Geometry[] geometryArray = new Geometry[2];
        this.geom = geometryArray;
        geometryArray[0] = geometry;
        geometryArray[1] = geometry2;
        this.terminateDistance = d;
    }

    private void computeMinDistance() {
        if (this.minDistanceLocation != null) {
            return;
        }
        this.minDistanceLocation = new GeometryLocation[2];
        int n = this.mostPolygonalIndex();
        boolean bl = n == 0;
        Geometry[] geometryArray = this.geom;
        this.computeMinDistanceMultiMulti(geometryArray[n], geometryArray[1 - n], bl);
    }

    private void computeMinDistance(Geometry geometry, Geometry geometry2, boolean bl) {
        if (geometry instanceof Point) {
            if (geometry2 instanceof Point) {
                this.computeMinDistancePointPoint((Point)geometry, (Point)geometry2, bl);
                return;
            }
            if (geometry2 instanceof LineString) {
                this.computeMinDistanceLinePoint((LineString)geometry2, (Point)geometry, bl ^ true);
                return;
            }
            if (geometry2 instanceof Polygon) {
                this.computeMinDistancePolygonPoint(Distance3DOp.polyPlane(geometry2), (Point)geometry, bl ^ true);
                return;
            }
        }
        if (geometry instanceof LineString) {
            if (geometry2 instanceof Point) {
                this.computeMinDistanceLinePoint((LineString)geometry, (Point)geometry2, bl);
                return;
            }
            if (geometry2 instanceof LineString) {
                this.computeMinDistanceLineLine((LineString)geometry, (LineString)geometry2, bl);
                return;
            }
            if (geometry2 instanceof Polygon) {
                this.computeMinDistancePolygonLine(Distance3DOp.polyPlane(geometry2), (LineString)geometry, bl ^ true);
                return;
            }
        }
        if (geometry instanceof Polygon) {
            if (geometry2 instanceof Point) {
                this.computeMinDistancePolygonPoint(Distance3DOp.polyPlane(geometry), (Point)geometry2, bl);
                return;
            }
            if (geometry2 instanceof LineString) {
                this.computeMinDistancePolygonLine(Distance3DOp.polyPlane(geometry), (LineString)geometry2, bl);
                return;
            }
            if (geometry2 instanceof Polygon) {
                this.computeMinDistancePolygonPolygon(Distance3DOp.polyPlane(geometry), (Polygon)geometry2, bl);
            }
        }
    }

    private void computeMinDistanceLineLine(LineString lineString, LineString lineString2, boolean bl) {
        Coordinate[] coordinateArray = lineString.getCoordinates();
        Coordinate[] coordinateArray2 = lineString2.getCoordinates();
        int n = 0;
        block0: while (n < coordinateArray.length - 1) {
            int n2 = 0;
            while (true) {
                if (n2 >= coordinateArray2.length - 1) {
                    ++n;
                    continue block0;
                }
                Coordinate coordinate = coordinateArray[n];
                int n3 = n + 1;
                Coordinate coordinate2 = coordinateArray[n3];
                Coordinate[] coordinateArray3 = coordinateArray2[n2];
                int n4 = n2 + 1;
                double d = CGAlgorithms3D.distanceSegmentSegment(coordinate, coordinate2, (Coordinate)coordinateArray3, coordinateArray2[n4]);
                if (d < this.minDistance) {
                    this.minDistance = d;
                    coordinateArray3 = new LineSegment(coordinateArray[n], coordinateArray[n3]).closestPoints(new LineSegment(coordinateArray2[n2], coordinateArray2[n4]));
                    this.updateDistance(d, new GeometryLocation(lineString, n, coordinateArray3[0]), new GeometryLocation(lineString2, n2, coordinateArray3[1]), bl);
                }
                if (this.isDone) {
                    return;
                }
                n2 = n4;
            }
            break;
        }
        return;
    }

    private void computeMinDistanceLinePoint(LineString lineString, Point point, boolean bl) {
        Coordinate[] coordinateArray = lineString.getCoordinates();
        Coordinate coordinate = point.getCoordinate();
        int n = 0;
        while (n < coordinateArray.length - 1) {
            Coordinate coordinate2 = coordinateArray[n];
            int n2 = n + 1;
            double d = CGAlgorithms3D.distancePointSegment(coordinate, coordinate2, coordinateArray[n2]);
            if (d < this.minDistance) {
                this.updateDistance(d, new GeometryLocation(lineString, n, new LineSegment(coordinateArray[n], coordinateArray[n2]).closestPoint(coordinate)), new GeometryLocation(point, 0, coordinate), bl);
            }
            if (this.isDone) {
                return;
            }
            n = n2;
        }
        return;
    }

    private void computeMinDistanceMultiMulti(Geometry geometry, Geometry geometry2, boolean bl) {
        if (geometry instanceof GeometryCollection) {
            int n = geometry.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                this.computeMinDistanceMultiMulti(geometry.getGeometryN(i), geometry2, bl);
                if (!this.isDone) continue;
                return;
            }
        } else {
            if (geometry.isEmpty()) {
                return;
            }
            if (geometry instanceof Polygon) {
                this.computeMinDistanceOneMulti(Distance3DOp.polyPlane(geometry), geometry2, bl);
            } else {
                this.computeMinDistanceOneMulti(geometry, geometry2, bl);
            }
        }
    }

    private void computeMinDistanceOneMulti(Geometry geometry, Geometry geometry2, boolean bl) {
        if (geometry2 instanceof GeometryCollection) {
            int n = geometry2.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                this.computeMinDistanceOneMulti(geometry, geometry2.getGeometryN(i), bl);
                if (!this.isDone) continue;
                return;
            }
        } else {
            this.computeMinDistance(geometry, geometry2, bl);
        }
    }

    private void computeMinDistanceOneMulti(PlanarPolygon3D planarPolygon3D, Geometry geometry, boolean bl) {
        if (geometry instanceof GeometryCollection) {
            int n = geometry.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                this.computeMinDistanceOneMulti(planarPolygon3D, geometry.getGeometryN(i), bl);
                if (!this.isDone) continue;
                return;
            }
        } else {
            if (geometry instanceof Point) {
                this.computeMinDistancePolygonPoint(planarPolygon3D, (Point)geometry, bl);
                return;
            }
            if (geometry instanceof LineString) {
                this.computeMinDistancePolygonLine(planarPolygon3D, (LineString)geometry, bl);
                return;
            }
            if (geometry instanceof Polygon) {
                this.computeMinDistancePolygonPolygon(planarPolygon3D, (Polygon)geometry, bl);
            }
        }
    }

    private void computeMinDistancePointPoint(Point point, Point point2, boolean bl) {
        double d = CGAlgorithms3D.distance(point.getCoordinate(), point2.getCoordinate());
        if (d < this.minDistance) {
            this.updateDistance(d, new GeometryLocation(point, 0, point.getCoordinate()), new GeometryLocation(point2, 0, point2.getCoordinate()), bl);
        }
    }

    private void computeMinDistancePolygonLine(PlanarPolygon3D planarPolygon3D, LineString lineString, boolean bl) {
        Coordinate coordinate = this.intersection(planarPolygon3D, lineString);
        int n = 0;
        if (coordinate != null) {
            this.updateDistance(0.0, new GeometryLocation(planarPolygon3D.getPolygon(), 0, coordinate), new GeometryLocation(lineString, 0, coordinate), bl);
            return;
        }
        this.computeMinDistanceLineLine(planarPolygon3D.getPolygon().getExteriorRing(), lineString, bl);
        if (this.isDone) {
            return;
        }
        int n2 = planarPolygon3D.getPolygon().getNumInteriorRing();
        while (n < n2) {
            this.computeMinDistanceLineLine(planarPolygon3D.getPolygon().getInteriorRingN(n), lineString, bl);
            if (this.isDone) {
                return;
            }
            ++n;
        }
        return;
    }

    private void computeMinDistancePolygonPoint(PlanarPolygon3D planarPolygon3D, Point point, boolean bl) {
        LineString lineString;
        Coordinate coordinate = point.getCoordinate();
        if (planarPolygon3D.intersects(coordinate, lineString = planarPolygon3D.getPolygon().getExteriorRing())) {
            int n = planarPolygon3D.getPolygon().getNumInteriorRing();
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    this.updateDistance(Math.abs(planarPolygon3D.getPlane().orientedDistance(coordinate)), new GeometryLocation(planarPolygon3D.getPolygon(), 0, coordinate), new GeometryLocation(point, 0, coordinate), bl);
                    break;
                }
                LineString lineString2 = planarPolygon3D.getPolygon().getInteriorRingN(n2);
                if (planarPolygon3D.intersects(coordinate, lineString2)) {
                    this.computeMinDistanceLinePoint(lineString2, point, bl);
                    return;
                }
                ++n2;
            }
        }
        this.computeMinDistanceLinePoint(lineString, point, bl);
    }

    private void computeMinDistancePolygonPolygon(PlanarPolygon3D planarPolygon3D, Polygon polygon, boolean bl) {
        this.computeMinDistancePolygonRings(planarPolygon3D, polygon, bl);
        if (this.isDone) {
            return;
        }
        this.computeMinDistancePolygonRings(new PlanarPolygon3D(polygon), planarPolygon3D.getPolygon(), bl);
    }

    private void computeMinDistancePolygonRings(PlanarPolygon3D planarPolygon3D, Polygon polygon, boolean bl) {
        this.computeMinDistancePolygonLine(planarPolygon3D, polygon.getExteriorRing(), bl);
        if (this.isDone) {
            return;
        }
        int n = polygon.getNumInteriorRing();
        int n2 = 0;
        while (n2 < n) {
            this.computeMinDistancePolygonLine(planarPolygon3D, polygon.getInteriorRingN(n2), bl);
            if (this.isDone) {
                return;
            }
            ++n2;
        }
        return;
    }

    public static double distance(Geometry geometry, Geometry geometry2) {
        return new Distance3DOp(geometry, geometry2).distance();
    }

    private Coordinate intersection(PlanarPolygon3D planarPolygon3D, LineString cloneable) {
        CoordinateSequence coordinateSequence = cloneable.getCoordinateSequence();
        if (coordinateSequence.size() == 0) {
            return null;
        }
        cloneable = new Coordinate();
        int n = 0;
        coordinateSequence.getCoordinate(0, (Coordinate)cloneable);
        double d = planarPolygon3D.getPlane().orientedDistance((Coordinate)cloneable);
        Coordinate coordinate = new Coordinate();
        while (n < coordinateSequence.size() - 1) {
            coordinateSequence.getCoordinate(n, (Coordinate)cloneable);
            coordinateSequence.getCoordinate(++n, coordinate);
            double d2 = planarPolygon3D.getPlane().orientedDistance(coordinate);
            if (d * d2 > 0.0) continue;
            Coordinate coordinate2 = Distance3DOp.segmentPoint((Coordinate)cloneable, coordinate, d, d2);
            if (planarPolygon3D.intersects(coordinate2)) {
                return coordinate2;
            }
            d = d2;
        }
        return null;
    }

    public static boolean isWithinDistance(Geometry geometry, Geometry geometry2, double d) {
        return new Distance3DOp(geometry, geometry2, d).distance() <= d;
    }

    private int mostPolygonalIndex() {
        int n = this.geom[0].getDimension();
        int n2 = this.geom[1].getDimension();
        if (n >= 2 && n2 >= 2) {
            if (this.geom[0].getNumPoints() > this.geom[1].getNumPoints()) {
                return 0;
            }
            return 1;
        }
        if (n >= 2) {
            return 0;
        }
        if (n2 >= 2) {
            return 1;
        }
        return 0;
    }

    public static Coordinate[] nearestPoints(Geometry geometry, Geometry geometry2) {
        return new Distance3DOp(geometry, geometry2).nearestPoints();
    }

    private static PlanarPolygon3D polyPlane(Geometry geometry) {
        return new PlanarPolygon3D((Polygon)geometry);
    }

    private static Coordinate segmentPoint(Coordinate coordinate, Coordinate coordinate2, double d, double d2) {
        if (d <= 0.0) {
            return new Coordinate(coordinate);
        }
        if (d2 <= 0.0) {
            return new Coordinate(coordinate2);
        }
        d = Math.abs(d) / (Math.abs(d) + Math.abs(d2));
        return new Coordinate(coordinate.x + (coordinate2.x - coordinate.x) * d, coordinate.y + (coordinate2.y - coordinate.y) * d, coordinate.z + d * (coordinate2.z - coordinate.z));
    }

    private void updateDistance(double d, GeometryLocation geometryLocation, GeometryLocation geometryLocation2, boolean bl) {
        this.minDistance = d;
        GeometryLocation[] geometryLocationArray = this.minDistanceLocation;
        geometryLocationArray[bl] = geometryLocation;
        geometryLocationArray[1 - bl] = geometryLocation2;
        if (d < this.terminateDistance) {
            this.isDone = true;
        }
    }

    public double distance() {
        Geometry[] geometryArray = this.geom;
        if (geometryArray[0] != null && geometryArray[1] != null) {
            if (!geometryArray[0].isEmpty() && !this.geom[1].isEmpty()) {
                this.computeMinDistance();
                return this.minDistance;
            }
            return 0.0;
        }
        throw new IllegalArgumentException("null geometries are not supported");
    }

    public GeometryLocation[] nearestLocations() {
        this.computeMinDistance();
        return this.minDistanceLocation;
    }

    public Coordinate[] nearestPoints() {
        this.computeMinDistance();
        return new Coordinate[]{this.minDistanceLocation[0].getCoordinate(), this.minDistanceLocation[1].getCoordinate()};
    }
}

