/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.linemerge;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.operation.linemerge.LineMergeEdge;
import com.vividsolutions.jts.operation.linemerge.LineMergeGraph;
import com.vividsolutions.jts.planargraph.DirectedEdge;
import com.vividsolutions.jts.planargraph.GraphComponent;
import com.vividsolutions.jts.planargraph.Node;
import com.vividsolutions.jts.planargraph.Subgraph;
import com.vividsolutions.jts.planargraph.algorithm.ConnectedSubgraphFinder;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;

public class LineSequencer {
    private GeometryFactory factory;
    private LineMergeGraph graph = new LineMergeGraph();
    private boolean isRun = false;
    private boolean isSequenceable = false;
    private int lineCount = 0;
    private Geometry sequencedGeometry = null;

    public LineSequencer() {
        this.factory = new GeometryFactory();
    }

    private void addLine(LineString lineString) {
        if (this.factory == null) {
            this.factory = lineString.getFactory();
        }
        this.graph.addEdge(lineString);
        ++this.lineCount;
    }

    private void addReverseSubpath(DirectedEdge graphComponent, ListIterator listIterator, boolean bl) {
        Node node = graphComponent.getToNode();
        while (true) {
            listIterator.add(graphComponent.getSym());
            GraphComponent graphComponent2 = graphComponent.getEdge();
            boolean bl2 = true;
            graphComponent2.setVisited(true);
            graphComponent = graphComponent.getFromNode();
            graphComponent2 = LineSequencer.findUnvisitedBestOrientedDE((Node)graphComponent);
            if (graphComponent2 == null) {
                if (bl) {
                    bl = graphComponent == node ? bl2 : false;
                    Assert.isTrue(bl, "path not contiguous");
                }
                return;
            }
            graphComponent = ((DirectedEdge)graphComponent2).getSym();
        }
    }

    private Geometry buildSequencedGeometry(List object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator2 = object.iterator();
        block0: while (true) {
            if (!iterator2.hasNext()) {
                if (arrayList.size() == 0) {
                    return this.factory.createMultiLineString(new LineString[0]);
                }
                return this.factory.buildGeometry(arrayList);
            }
            Iterator iterator3 = ((List)iterator2.next()).iterator();
            while (true) {
                if (!iterator3.hasNext()) continue block0;
                DirectedEdge directedEdge = (DirectedEdge)iterator3.next();
                LineString lineString = ((LineMergeEdge)directedEdge.getEdge()).getLine();
                object = lineString;
                if (!directedEdge.getEdgeDirection()) {
                    object = lineString;
                    if (!lineString.isClosed()) {
                        object = LineSequencer.reverse(lineString);
                    }
                }
                arrayList.add(object);
            }
            break;
        }
    }

    private void computeSequence() {
        if (this.isRun) {
            return;
        }
        boolean bl = true;
        this.isRun = true;
        Object object = this.findSequences();
        if (object == null) {
            return;
        }
        this.sequencedGeometry = object = this.buildSequencedGeometry((List)object);
        this.isSequenceable = true;
        int n = ((Geometry)object).getNumGeometries();
        boolean bl2 = this.lineCount == n;
        Assert.isTrue(bl2, "Lines were missing from result");
        object = this.sequencedGeometry;
        bl2 = bl;
        if (!(object instanceof LineString)) {
            bl2 = bl;
            if (!(object instanceof MultiLineString)) {
                bl2 = false;
            }
        }
        Assert.isTrue(bl2, "Result is not lineal");
    }

    private static Node findLowestDegreeNode(Subgraph object) {
        Iterator iterator2 = ((Subgraph)object).nodeIterator();
        int n = Integer.MAX_VALUE;
        object = null;
        while (iterator2.hasNext()) {
            Node node = (Node)iterator2.next();
            if (object != null && node.getDegree() >= n) continue;
            n = node.getDegree();
            object = node;
        }
        return object;
    }

    private List findSequence(Subgraph object) {
        GraphComponent.setVisited(((Subgraph)object).edgeIterator(), false);
        DirectedEdge directedEdge = ((DirectedEdge)LineSequencer.findLowestDegreeNode((Subgraph)object).getOutEdges().iterator().next()).getSym();
        LinkedList linkedList = new LinkedList();
        object = linkedList.listIterator();
        this.addReverseSubpath(directedEdge, (ListIterator)object, false);
        while (object.hasPrevious()) {
            directedEdge = LineSequencer.findUnvisitedBestOrientedDE(((DirectedEdge)object.previous()).getFromNode());
            if (directedEdge == null) continue;
            this.addReverseSubpath(directedEdge.getSym(), (ListIterator)object, true);
        }
        return this.orient(linkedList);
    }

    private List findSequences() {
        ArrayList<List> arrayList = new ArrayList<List>();
        Iterator iterator2 = new ConnectedSubgraphFinder(this.graph).getConnectedSubgraphs().iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                return arrayList;
            }
            Subgraph subgraph = (Subgraph)iterator2.next();
            if (!this.hasSequence(subgraph)) break;
            arrayList.add(this.findSequence(subgraph));
        }
        return null;
    }

    private static DirectedEdge findUnvisitedBestOrientedDE(Node graphComponent) {
        Iterator iterator2 = graphComponent.getOutEdges().iterator();
        graphComponent = null;
        block0: while (true) {
            GraphComponent graphComponent2 = graphComponent;
            while (true) {
                if (!iterator2.hasNext()) {
                    if (graphComponent != null) {
                        return graphComponent;
                    }
                    return graphComponent2;
                }
                DirectedEdge directedEdge = (DirectedEdge)iterator2.next();
                if (directedEdge.getEdge().isVisited()) continue;
                if (directedEdge.getEdgeDirection()) {
                    graphComponent = directedEdge;
                    continue block0;
                }
                graphComponent2 = directedEdge;
            }
            break;
        }
    }

    private boolean hasSequence(Subgraph object) {
        object = ((Subgraph)object).nodeIterator();
        int n = 0;
        while (object.hasNext()) {
            if (((Node)object.next()).getDegree() % 2 != 1) continue;
            ++n;
        }
        return n <= 2;
    }

    public static boolean isSequenced(Geometry geometry) {
        if (!(geometry instanceof MultiLineString)) {
            return true;
        }
        MultiLineString multiLineString = (MultiLineString)geometry;
        TreeSet treeSet = new TreeSet();
        geometry = null;
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        int n = 0;
        while (n < multiLineString.getNumGeometries()) {
            Cloneable cloneable = (LineString)multiLineString.getGeometryN(n);
            Coordinate coordinate = cloneable.getCoordinateN(0);
            cloneable = cloneable.getCoordinateN(cloneable.getNumPoints() - 1);
            if (treeSet.contains(coordinate)) {
                return false;
            }
            if (treeSet.contains(cloneable)) {
                return false;
            }
            if (geometry != null && !coordinate.equals(geometry)) {
                treeSet.addAll(arrayList);
                arrayList.clear();
            }
            arrayList.add(coordinate);
            arrayList.add((Comparable)((Object)cloneable));
            ++n;
            geometry = cloneable;
        }
        return true;
    }

    private List orient(List list) {
        boolean bl = false;
        boolean bl2 = false;
        DirectedEdge directedEdge = (DirectedEdge)list.get(0);
        Object object = (DirectedEdge)list.get(list.size() - 1);
        Node node = directedEdge.getFromNode();
        Node node2 = ((DirectedEdge)object).getToNode();
        boolean bl3 = node.getDegree() == 1 || node2.getDegree() == 1;
        if (bl3) {
            if (((DirectedEdge)object).getToNode().getDegree() == 1 && !((DirectedEdge)object).getEdgeDirection()) {
                bl = true;
                bl3 = true;
            } else {
                bl = false;
                bl3 = false;
            }
            if (directedEdge.getFromNode().getDegree() == 1 && directedEdge.getEdgeDirection()) {
                bl = true;
                bl3 = bl2;
                bl2 = bl;
            } else {
                bl2 = bl;
            }
            bl = bl3;
            if (!bl2) {
                bl = bl3;
                if (directedEdge.getFromNode().getDegree() == 1) {
                    bl = true;
                }
            }
        }
        object = list;
        if (bl) {
            object = this.reverse(list);
        }
        return object;
    }

    private static LineString reverse(LineString lineString) {
        Coordinate[] coordinateArray = lineString.getCoordinates();
        Coordinate[] coordinateArray2 = new Coordinate[coordinateArray.length];
        int n = coordinateArray.length;
        int n2 = 0;
        while (n2 < n) {
            coordinateArray2[n - 1 - n2] = new Coordinate(coordinateArray[n2]);
            ++n2;
        }
        return lineString.getFactory().createLineString(coordinateArray2);
    }

    private List reverse(List object) {
        LinkedList<DirectedEdge> linkedList = new LinkedList<DirectedEdge>();
        object = object.iterator();
        while (object.hasNext()) {
            linkedList.addFirst(((DirectedEdge)object.next()).getSym());
        }
        return linkedList;
    }

    public static Geometry sequence(Geometry geometry) {
        LineSequencer lineSequencer = new LineSequencer();
        lineSequencer.add(geometry);
        return lineSequencer.getSequencedLineStrings();
    }

    public void add(Geometry geometry) {
        geometry.apply(new GeometryComponentFilter(){

            @Override
            public void filter(Geometry geometry) {
                if (geometry instanceof LineString) {
                    LineSequencer.this.addLine((LineString)geometry);
                }
            }
        });
    }

    public void add(Collection object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.add((Geometry)object.next());
        }
        return;
    }

    public Geometry getSequencedLineStrings() {
        this.computeSequence();
        return this.sequencedGeometry;
    }

    public boolean isSequenceable() {
        this.computeSequence();
        return this.isSequenceable;
    }
}

