/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.EdgeEndStar;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConsistentPolygonRingChecker {
    private final int LINKING_TO_OUTGOING;
    private final int SCANNING_FOR_INCOMING;
    private PlanarGraph graph;

    public ConsistentPolygonRingChecker(PlanarGraph planarGraph) {
        this.SCANNING_FOR_INCOMING = 1;
        this.LINKING_TO_OUTGOING = 2;
        this.graph = planarGraph;
    }

    private List getPotentialResultAreaEdges(DirectedEdgeStar object, int n) {
        ArrayList<DirectedEdge> arrayList = new ArrayList<DirectedEdge>();
        object = ((EdgeEndStar)object).iterator();
        while (object.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)object.next();
            if (!this.isPotentialResultAreaEdge(directedEdge, n) && !this.isPotentialResultAreaEdge(directedEdge.getSym(), n)) continue;
            arrayList.add(directedEdge);
        }
        return arrayList;
    }

    private boolean isPotentialResultAreaEdge(DirectedEdge directedEdge, int n) {
        Label label = directedEdge.getLabel();
        return label.isArea() && !directedEdge.isInteriorAreaEdge() && OverlayOp.isResultOfOp(label.getLocation(0, 2), label.getLocation(1, 2), n);
    }

    private void testLinkResultDirectedEdges(DirectedEdgeStar directedEdgeStar, int n) {
        List list = this.getPotentialResultAreaEdges(directedEdgeStar, n);
        DirectedEdge directedEdge = null;
        int n2 = 0;
        int n3 = 1;
        while (true) {
            DirectedEdge directedEdge2;
            if (n2 >= list.size()) {
                if (n3 == 2 && directedEdge == null) {
                    throw new TopologyException("no outgoing dirEdge found", directedEdgeStar.getCoordinate());
                }
                return;
            }
            DirectedEdge directedEdge3 = (DirectedEdge)list.get(n2);
            DirectedEdge directedEdge4 = directedEdge3.getSym();
            if (!directedEdge3.getLabel().isArea()) {
                directedEdge2 = directedEdge;
            } else {
                directedEdge2 = directedEdge;
                if (directedEdge == null) {
                    directedEdge2 = directedEdge;
                    if (this.isPotentialResultAreaEdge(directedEdge3, n)) {
                        directedEdge2 = directedEdge3;
                    }
                }
                if (n3 != 1) {
                    if (n3 == 2 && this.isPotentialResultAreaEdge(directedEdge3, n)) {
                        n3 = 1;
                    }
                } else if (this.isPotentialResultAreaEdge(directedEdge4, n)) {
                    n3 = 2;
                }
            }
            ++n2;
            directedEdge = directedEdge2;
        }
    }

    public void check(int n) {
        Iterator iterator2 = this.graph.getNodeIterator();
        while (iterator2.hasNext()) {
            this.testLinkResultDirectedEdges((DirectedEdgeStar)((Node)iterator2.next()).getEdges(), n);
        }
        return;
    }

    public void checkAll() {
        this.check(1);
        this.check(3);
        this.check(2);
        this.check(4);
    }
}

