/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeRing;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.operation.overlay.MaximalEdgeRing;
import com.vividsolutions.jts.operation.overlay.MinimalEdgeRing;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PolygonBuilder {
    private GeometryFactory geometryFactory;
    private List shellList = new ArrayList();

    public PolygonBuilder(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    private List buildMaximalEdgeRings(Collection object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (DirectedEdge)object.next();
            if (!((DirectedEdge)object2).isInResult() || !((EdgeEnd)object2).getLabel().isArea() || ((DirectedEdge)object2).getEdgeRing() != null) continue;
            object2 = new MaximalEdgeRing((DirectedEdge)object2, this.geometryFactory);
            arrayList.add(object2);
            ((EdgeRing)object2).setInResult();
        }
        return arrayList;
    }

    private List buildMinimalEdgeRings(List object, List list, List list2) {
        ArrayList<MaximalEdgeRing> arrayList = new ArrayList<MaximalEdgeRing>();
        object = object.iterator();
        while (object.hasNext()) {
            EdgeRing edgeRing = (MaximalEdgeRing)object.next();
            if (edgeRing.getMaxNodeDegree() > 2) {
                edgeRing.linkDirectedEdgesForMinimalEdgeRings();
                List list3 = edgeRing.buildMinimalRings();
                edgeRing = this.findShell(list3);
                if (edgeRing != null) {
                    this.placePolygonHoles(edgeRing, list3);
                    list.add(edgeRing);
                    continue;
                }
                list2.addAll(list3);
                continue;
            }
            arrayList.add((MaximalEdgeRing)edgeRing);
        }
        return arrayList;
    }

    private List computePolygons(List object) {
        ArrayList<Polygon> arrayList = new ArrayList<Polygon>();
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add(((EdgeRing)object.next()).toPolygon(this.geometryFactory));
        }
        return arrayList;
    }

    private EdgeRing findEdgeRingContaining(EdgeRing object, List object2) {
        object = ((EdgeRing)object).getLinearRing();
        Envelope envelope = ((Geometry)object).getEnvelopeInternal();
        Coordinate coordinate = ((LineString)object).getCoordinateN(0);
        Iterator iterator2 = object2.iterator();
        object = null;
        Object object3 = null;
        while (iterator2.hasNext()) {
            EdgeRing edgeRing = (EdgeRing)iterator2.next();
            LinearRing linearRing = edgeRing.getLinearRing();
            Envelope envelope2 = linearRing.getEnvelopeInternal();
            object2 = object3;
            if (object != null) {
                object2 = ((EdgeRing)object).getLinearRing().getEnvelopeInternal();
            }
            boolean bl = envelope2.contains(envelope) && CGAlgorithms.isPointInRing(coordinate, linearRing.getCoordinates());
            object3 = object2;
            if (!bl) continue;
            if (object != null) {
                object3 = object2;
                if (!((Envelope)object2).contains(envelope2)) continue;
            }
            object = edgeRing;
            object3 = object2;
        }
        return object;
    }

    private EdgeRing findShell(List object) {
        Iterator iterator2 = object.iterator();
        boolean bl = false;
        object = null;
        int n = 0;
        while (true) {
            if (!iterator2.hasNext()) {
                if (n <= 1) {
                    bl = true;
                }
                Assert.isTrue(bl, "found two shells in MinimalEdgeRing list");
                return object;
            }
            MinimalEdgeRing minimalEdgeRing = (MinimalEdgeRing)iterator2.next();
            if (minimalEdgeRing.isHole()) continue;
            ++n;
            object = minimalEdgeRing;
        }
    }

    private void placeFreeHoles(List list, List object) {
        Iterator iterator2 = object.iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                return;
            }
            object = (EdgeRing)iterator2.next();
            if (((EdgeRing)object).getShell() != null) continue;
            EdgeRing edgeRing = this.findEdgeRingContaining((EdgeRing)object, list);
            if (edgeRing == null) break;
            ((EdgeRing)object).setShell(edgeRing);
        }
        throw new TopologyException("unable to assign hole to a shell", ((EdgeRing)object).getCoordinate(0));
    }

    private void placePolygonHoles(EdgeRing edgeRing, List object) {
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = (MinimalEdgeRing)iterator2.next();
            if (!((EdgeRing)object).isHole()) continue;
            ((EdgeRing)object).setShell(edgeRing);
        }
        return;
    }

    private void sortShellsAndHoles(List object, List list, List list2) {
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = (EdgeRing)iterator2.next();
            if (((EdgeRing)object).isHole()) {
                list2.add(object);
                continue;
            }
            list.add(object);
        }
        return;
    }

    public void add(PlanarGraph planarGraph) {
        this.add(planarGraph.getEdgeEnds(), planarGraph.getNodes());
    }

    public void add(Collection arrayList, Collection collection) {
        PlanarGraph.linkResultDirectedEdges(collection);
        collection = this.buildMaximalEdgeRings(arrayList);
        arrayList = new ArrayList();
        this.sortShellsAndHoles(this.buildMinimalEdgeRings((List)collection, this.shellList, arrayList), this.shellList, arrayList);
        this.placeFreeHoles(this.shellList, arrayList);
    }

    public boolean containsPoint(Coordinate coordinate) {
        Iterator iterator2 = this.shellList.iterator();
        do {
            if (iterator2.hasNext()) continue;
            return false;
        } while (!((EdgeRing)iterator2.next()).containsPoint(coordinate));
        return true;
    }

    public List getPolygons() {
        return this.computePolygons(this.shellList);
    }
}

