/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay.snap;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.operation.overlay.snap.SnapTransformer;
import java.util.TreeSet;

public class GeometrySnapper {
    private static final double SNAP_PRECISION_FACTOR = 1.0E-9;
    private Geometry srcGeom;

    public GeometrySnapper(Geometry geometry) {
        this.srcGeom = geometry;
    }

    private double computeMinimumSegmentLength(Coordinate[] coordinateArray) {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < coordinateArray.length - 1) {
            Coordinate coordinate = coordinateArray[n];
            int n2 = n + 1;
            double d2 = coordinate.distance(coordinateArray[n2]);
            n = n2;
            if (!(d2 < d)) continue;
            d = d2;
            n = n2;
        }
        return d;
    }

    public static double computeOverlaySnapTolerance(Geometry comparable) {
        double d = GeometrySnapper.computeSizeBasedSnapTolerance((Geometry)comparable);
        comparable = ((Geometry)comparable).getPrecisionModel();
        double d2 = d;
        if (((PrecisionModel)comparable).getType() == PrecisionModel.FIXED) {
            double d3 = 1.0 / ((PrecisionModel)comparable).getScale() * 2.0 / 1.415;
            d2 = d;
            if (d3 > d) {
                d2 = d3;
            }
        }
        return d2;
    }

    public static double computeOverlaySnapTolerance(Geometry geometry, Geometry geometry2) {
        return Math.min(GeometrySnapper.computeOverlaySnapTolerance(geometry), GeometrySnapper.computeOverlaySnapTolerance(geometry2));
    }

    public static double computeSizeBasedSnapTolerance(Geometry comparable) {
        comparable = ((Geometry)comparable).getEnvelopeInternal();
        return Math.min(((Envelope)comparable).getHeight(), ((Envelope)comparable).getWidth()) * 1.0E-9;
    }

    private double computeSnapTolerance(Coordinate[] coordinateArray) {
        return this.computeMinimumSegmentLength(coordinateArray) / 10.0;
    }

    private Coordinate[] extractTargetCoordinates(Geometry coordinateArray) {
        TreeSet<Coordinate> treeSet = new TreeSet<Coordinate>();
        coordinateArray = coordinateArray.getCoordinates();
        int n = 0;
        while (n < coordinateArray.length) {
            treeSet.add(coordinateArray[n]);
            ++n;
        }
        return treeSet.toArray(new Coordinate[0]);
    }

    public static Geometry[] snap(Geometry geometry, Geometry geometry2, double d) {
        Geometry[] geometryArray;
        geometryArray = new Geometry[]{new GeometrySnapper(geometry).snapTo(geometry2, d), new GeometrySnapper(geometry2).snapTo(geometryArray[0], d)};
        return geometryArray;
    }

    public static Geometry snapToSelf(Geometry geometry, double d, boolean bl) {
        return new GeometrySnapper(geometry).snapToSelf(d, bl);
    }

    public Geometry snapTo(Geometry geometry, double d) {
        return new SnapTransformer(d, this.extractTargetCoordinates(geometry)).transform(this.srcGeom);
    }

    public Geometry snapToSelf(double d, boolean bl) {
        Geometry geometry;
        Geometry geometry2 = geometry = new SnapTransformer(d, this.extractTargetCoordinates(this.srcGeom), true).transform(this.srcGeom);
        if (bl) {
            geometry2 = geometry;
            if (geometry instanceof Polygonal) {
                geometry2 = geometry.buffer(0.0);
            }
        }
        return geometry2;
    }
}

