/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay.snap;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import com.vividsolutions.jts.operation.overlay.snap.GeometrySnapper;
import com.vividsolutions.jts.precision.CommonBitsRemover;

public class SnapOverlayOp {
    private CommonBitsRemover cbr;
    private Geometry[] geom;
    private double snapTolerance;

    public SnapOverlayOp(Geometry geometry, Geometry geometry2) {
        Geometry[] geometryArray = new Geometry[2];
        this.geom = geometryArray;
        geometryArray[0] = geometry;
        geometryArray[1] = geometry2;
        this.computeSnapTolerance();
    }

    private void checkValid(Geometry geometry) {
        if (!geometry.isValid()) {
            System.out.println("Snapped geometry is invalid");
        }
    }

    private void computeSnapTolerance() {
        Geometry[] geometryArray = this.geom;
        this.snapTolerance = GeometrySnapper.computeOverlaySnapTolerance(geometryArray[0], geometryArray[1]);
    }

    public static Geometry difference(Geometry geometry, Geometry geometry2) {
        return SnapOverlayOp.overlayOp(geometry, geometry2, 3);
    }

    public static Geometry intersection(Geometry geometry, Geometry geometry2) {
        return SnapOverlayOp.overlayOp(geometry, geometry2, 1);
    }

    public static Geometry overlayOp(Geometry geometry, Geometry geometry2, int n) {
        return new SnapOverlayOp(geometry, geometry2).getResultGeometry(n);
    }

    private Geometry prepareResult(Geometry geometry) {
        this.cbr.addCommonBits(geometry);
        return geometry;
    }

    private Geometry[] removeCommonBits(Geometry[] geometryArray) {
        CommonBitsRemover commonBitsRemover;
        this.cbr = commonBitsRemover = new CommonBitsRemover();
        commonBitsRemover.add(geometryArray[0]);
        this.cbr.add(geometryArray[1]);
        return new Geometry[]{this.cbr.removeCommonBits((Geometry)geometryArray[0].clone()), this.cbr.removeCommonBits((Geometry)geometryArray[1].clone())};
    }

    private Geometry selfSnap(Geometry geometry) {
        return new GeometrySnapper(geometry).snapTo(geometry, this.snapTolerance);
    }

    private Geometry[] snap(Geometry[] geometryArray) {
        geometryArray = this.removeCommonBits(geometryArray);
        return GeometrySnapper.snap(geometryArray[0], geometryArray[1], this.snapTolerance);
    }

    public static Geometry symDifference(Geometry geometry, Geometry geometry2) {
        return SnapOverlayOp.overlayOp(geometry, geometry2, 4);
    }

    public static Geometry union(Geometry geometry, Geometry geometry2) {
        return SnapOverlayOp.overlayOp(geometry, geometry2, 2);
    }

    public Geometry getResultGeometry(int n) {
        Geometry[] geometryArray = this.snap(this.geom);
        return this.prepareResult(OverlayOp.overlayOp(geometryArray[0], geometryArray[1], n));
    }
}

