/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.polygonize;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.operation.polygonize.PolygonizeDirectedEdge;
import com.vividsolutions.jts.operation.polygonize.PolygonizeEdge;
import com.vividsolutions.jts.planargraph.DirectedEdge;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

class EdgeRing {
    private List deList = new ArrayList();
    private GeometryFactory factory;
    private List holes;
    private boolean isHole;
    private boolean isIncluded = false;
    private boolean isIncludedSet = false;
    private boolean isProcessed = false;
    private DirectedEdge lowestEdge = null;
    private LinearRing ring = null;
    private Coordinate[] ringPts = null;
    private EdgeRing shell;

    public EdgeRing(GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
    }

    private void add(DirectedEdge directedEdge) {
        this.deList.add(directedEdge);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void addEdge(Coordinate[] coordinateArray, boolean bl, CoordinateList coordinateList) {
        if (bl) {
            int n = 0;
            while (true) {
                if (n >= coordinateArray.length) {
                    return;
                }
                coordinateList.add(coordinateArray[n], false);
                ++n;
            }
        }
        int n = coordinateArray.length - 1;
        while (n >= 0) {
            coordinateList.add(coordinateArray[n], false);
            --n;
        }
        return;
    }

    public static List findDirEdgesInRing(PolygonizeDirectedEdge polygonizeDirectedEdge) {
        PolygonizeDirectedEdge polygonizeDirectedEdge2;
        ArrayList<PolygonizeDirectedEdge> arrayList = new ArrayList<PolygonizeDirectedEdge>();
        PolygonizeDirectedEdge polygonizeDirectedEdge3 = polygonizeDirectedEdge;
        do {
            arrayList.add(polygonizeDirectedEdge3);
            polygonizeDirectedEdge2 = polygonizeDirectedEdge3.getNext();
            boolean bl = true;
            boolean bl2 = polygonizeDirectedEdge2 != null;
            Assert.isTrue(bl2, "found null DE in ring");
            bl2 = bl;
            if (polygonizeDirectedEdge2 != polygonizeDirectedEdge) {
                bl2 = bl;
                if (polygonizeDirectedEdge2.isInRing()) {
                    bl2 = false;
                }
            }
            Assert.isTrue(bl2, "found DE already in ring");
            polygonizeDirectedEdge3 = polygonizeDirectedEdge2;
        } while (polygonizeDirectedEdge2 != polygonizeDirectedEdge);
        return arrayList;
    }

    public static EdgeRing findEdgeRingContaining(EdgeRing edgeRing, List object) {
        LinearRing linearRing = edgeRing.getRing();
        Envelope envelope = linearRing.getEnvelopeInternal();
        linearRing.getCoordinateN(0);
        Iterator iterator2 = object.iterator();
        edgeRing = null;
        object = null;
        while (iterator2.hasNext()) {
            EdgeRing edgeRing2 = (EdgeRing)iterator2.next();
            LinearRing linearRing2 = edgeRing2.getRing();
            Envelope envelope2 = linearRing2.getEnvelopeInternal();
            if (envelope2.equals(envelope) || !envelope2.contains(envelope) || !CGAlgorithms.isPointInRing(CoordinateArrays.ptNotInList(linearRing.getCoordinates(), linearRing2.getCoordinates()), linearRing2.getCoordinates()) || edgeRing != null && !((Envelope)object).contains(envelope2)) continue;
            object = edgeRing2.getRing().getEnvelopeInternal();
            edgeRing = edgeRing2;
        }
        return edgeRing;
    }

    private Coordinate[] getCoordinates() {
        if (this.ringPts == null) {
            CoordinateList coordinateList = new CoordinateList();
            Iterator iterator2 = this.deList.iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    this.ringPts = coordinateList.toCoordinateArray();
                    break;
                }
                DirectedEdge directedEdge = (DirectedEdge)iterator2.next();
                EdgeRing.addEdge(((PolygonizeEdge)directedEdge.getEdge()).getLine().getCoordinates(), directedEdge.getEdgeDirection(), coordinateList);
            }
        }
        return this.ringPts;
    }

    public static boolean isInList(Coordinate coordinate, Coordinate[] coordinateArray) {
        int n = 0;
        while (n < coordinateArray.length) {
            if (coordinate.equals(coordinateArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static Coordinate ptNotInList(Coordinate[] coordinateArray, Coordinate[] coordinateArray2) {
        int n = 0;
        while (n < coordinateArray.length) {
            Coordinate coordinate = coordinateArray[n];
            if (!EdgeRing.isInList(coordinate, coordinateArray2)) {
                return coordinate;
            }
            ++n;
        }
        return null;
    }

    public void addHole(LinearRing linearRing) {
        if (this.holes == null) {
            this.holes = new ArrayList();
        }
        this.holes.add(linearRing);
    }

    public void addHole(EdgeRing object) {
        ((EdgeRing)object).setShell(this);
        object = ((EdgeRing)object).getRing();
        if (this.holes == null) {
            this.holes = new ArrayList();
        }
        this.holes.add(object);
    }

    public void build(PolygonizeDirectedEdge polygonizeDirectedEdge) {
        PolygonizeDirectedEdge polygonizeDirectedEdge2;
        PolygonizeDirectedEdge polygonizeDirectedEdge3 = polygonizeDirectedEdge;
        do {
            this.add(polygonizeDirectedEdge3);
            polygonizeDirectedEdge3.setRing(this);
            polygonizeDirectedEdge2 = polygonizeDirectedEdge3.getNext();
            boolean bl = true;
            boolean bl2 = polygonizeDirectedEdge2 != null;
            Assert.isTrue(bl2, "found null DE in ring");
            bl2 = bl;
            if (polygonizeDirectedEdge2 != polygonizeDirectedEdge) {
                bl2 = bl;
                if (polygonizeDirectedEdge2.isInRing()) {
                    bl2 = false;
                }
            }
            Assert.isTrue(bl2, "found DE already in ring");
            polygonizeDirectedEdge3 = polygonizeDirectedEdge2;
        } while (polygonizeDirectedEdge2 != polygonizeDirectedEdge);
    }

    public void computeHole() {
        this.isHole = CGAlgorithms.isCCW(this.getRing().getCoordinates());
    }

    public LineString getLineString() {
        this.getCoordinates();
        return this.factory.createLineString(this.ringPts);
    }

    public EdgeRing getOuterHole() {
        if (this.isHole()) {
            return null;
        }
        int n = 0;
        while (n < this.deList.size()) {
            EdgeRing edgeRing = ((PolygonizeDirectedEdge)((PolygonizeDirectedEdge)this.deList.get(n)).getSym()).getRing();
            if (edgeRing.isOuterHole()) {
                return edgeRing;
            }
            ++n;
        }
        return null;
    }

    public Polygon getPolygon() {
        LinearRing[] linearRingArray = this.holes;
        if (linearRingArray != null) {
            linearRingArray = new LinearRing[linearRingArray.size()];
            for (int i = 0; i < this.holes.size(); ++i) {
                linearRingArray[i] = (LinearRing)this.holes.get(i);
            }
        } else {
            linearRingArray = null;
        }
        return this.factory.createPolygon(this.ring, linearRingArray);
    }

    public LinearRing getRing() {
        LinearRing linearRing = this.ring;
        if (linearRing != null) {
            return linearRing;
        }
        this.getCoordinates();
        if (this.ringPts.length < 3) {
            System.out.println(this.ringPts);
        }
        try {
            this.ring = this.factory.createLinearRing(this.ringPts);
        }
        catch (Exception exception) {
            System.out.println(this.ringPts);
        }
        return this.ring;
    }

    public EdgeRing getShell() {
        if (this.isHole()) {
            return this.shell;
        }
        return this;
    }

    public boolean hasShell() {
        return this.shell != null;
    }

    public boolean isHole() {
        return this.isHole;
    }

    public boolean isIncluded() {
        return this.isIncluded;
    }

    public boolean isIncludedSet() {
        return this.isIncludedSet;
    }

    public boolean isOuterHole() {
        if (!this.isHole) {
            return false;
        }
        return this.hasShell() ^ true;
    }

    public boolean isOuterShell() {
        return this.getOuterHole() != null;
    }

    public boolean isProcessed() {
        return this.isProcessed;
    }

    public boolean isValid() {
        this.getCoordinates();
        if (this.ringPts.length <= 3) {
            return false;
        }
        this.getRing();
        return this.ring.isValid();
    }

    public void setIncluded(boolean bl) {
        this.isIncluded = bl;
        this.isIncludedSet = true;
    }

    public void setProcessed(boolean bl) {
        this.isProcessed = bl;
    }

    public void setShell(EdgeRing edgeRing) {
        this.shell = edgeRing;
    }

    public String toString() {
        return WKTWriter.toLineString(new CoordinateArraySequence(this.getCoordinates()));
    }

    public void updateIncluded() {
        if (this.isHole()) {
            return;
        }
        int n = 0;
        while (n < this.deList.size()) {
            EdgeRing edgeRing = ((PolygonizeDirectedEdge)((PolygonizeDirectedEdge)this.deList.get(n)).getSym()).getRing().getShell();
            if (edgeRing != null && edgeRing.isIncludedSet()) {
                this.setIncluded(edgeRing.isIncluded() ^ true);
                return;
            }
            ++n;
        }
        return;
    }

    static class EnvelopeComparator
    implements Comparator {
        EnvelopeComparator() {
        }

        public int compare(Object object, Object object2) {
            object = (EdgeRing)object;
            object2 = (EdgeRing)object2;
            return ((EdgeRing)object).getRing().getEnvelope().compareTo(((EdgeRing)object2).getRing().getEnvelope());
        }
    }
}

