/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.polygonize;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.polygonize.EdgeRing;
import com.vividsolutions.jts.operation.polygonize.PolygonizeDirectedEdge;
import com.vividsolutions.jts.operation.polygonize.PolygonizeEdge;
import com.vividsolutions.jts.planargraph.DirectedEdge;
import com.vividsolutions.jts.planargraph.Edge;
import com.vividsolutions.jts.planargraph.GraphComponent;
import com.vividsolutions.jts.planargraph.Node;
import com.vividsolutions.jts.planargraph.PlanarGraph;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

class PolygonizeGraph
extends PlanarGraph {
    private GeometryFactory factory;

    public PolygonizeGraph(GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
    }

    private void computeDepthParity(PolygonizeDirectedEdge polygonizeDirectedEdge) {
    }

    private static void computeNextCCWEdges(Node graphComponent, long l) {
        List list = ((Node)graphComponent).getOutEdges().getEdges();
        int n = list.size();
        boolean bl = true;
        --n;
        graphComponent = null;
        Node node = graphComponent;
        while (true) {
            GraphComponent graphComponent2;
            GraphComponent graphComponent3;
            if (n < 0) {
                if (graphComponent != null) {
                    if (node == null) {
                        bl = false;
                    }
                    Assert.isTrue(bl);
                    ((PolygonizeDirectedEdge)graphComponent).setNext((PolygonizeDirectedEdge)((Object)node));
                }
                return;
            }
            PolygonizeDirectedEdge polygonizeDirectedEdge = (PolygonizeDirectedEdge)list.get(n);
            GraphComponent graphComponent4 = (PolygonizeDirectedEdge)polygonizeDirectedEdge.getSym();
            if (polygonizeDirectedEdge.getLabel() != l) {
                polygonizeDirectedEdge = null;
            }
            if (graphComponent4.getLabel() != l) {
                graphComponent4 = null;
            }
            if (polygonizeDirectedEdge == null && graphComponent4 == null) {
                graphComponent3 = graphComponent;
                graphComponent2 = node;
            } else {
                if (graphComponent4 != null) {
                    graphComponent = graphComponent4;
                }
                graphComponent3 = graphComponent;
                graphComponent2 = node;
                if (polygonizeDirectedEdge != null) {
                    graphComponent4 = graphComponent;
                    if (graphComponent != null) {
                        ((PolygonizeDirectedEdge)graphComponent).setNext(polygonizeDirectedEdge);
                        graphComponent4 = null;
                    }
                    graphComponent3 = graphComponent4;
                    graphComponent2 = node;
                    if (node == null) {
                        graphComponent2 = polygonizeDirectedEdge;
                        graphComponent3 = graphComponent4;
                    }
                }
            }
            --n;
            graphComponent = graphComponent3;
            node = graphComponent2;
        }
    }

    private void computeNextCWEdges() {
        Iterator iterator2 = this.nodeIterator();
        while (iterator2.hasNext()) {
            PolygonizeGraph.computeNextCWEdges((Node)iterator2.next());
        }
        return;
    }

    private static void computeNextCWEdges(Node graphComponent) {
        Iterator iterator2 = graphComponent.getOutEdges().getEdges().iterator();
        DirectedEdge directedEdge = null;
        GraphComponent graphComponent2 = null;
        while (true) {
            if (!iterator2.hasNext()) {
                if (directedEdge != null) {
                    ((PolygonizeDirectedEdge)directedEdge.getSym()).setNext((PolygonizeDirectedEdge)graphComponent2);
                }
                return;
            }
            PolygonizeDirectedEdge polygonizeDirectedEdge = (PolygonizeDirectedEdge)iterator2.next();
            if (polygonizeDirectedEdge.isMarked()) continue;
            graphComponent = graphComponent2;
            if (graphComponent2 == null) {
                graphComponent = polygonizeDirectedEdge;
            }
            if (directedEdge != null) {
                ((PolygonizeDirectedEdge)directedEdge.getSym()).setNext(polygonizeDirectedEdge);
            }
            directedEdge = polygonizeDirectedEdge;
            graphComponent2 = graphComponent;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void convertMaximalToMinimalEdgeRings(List var1_1) {
        var1_1 = var1_1.iterator();
        block0: while (true) {
            if (!var1_1.hasNext()) {
                return;
            }
            var2_2 = (PolygonizeDirectedEdge)var1_1.next();
            var3_3 = var2_2.getLabel();
            if ((var2_2 = PolygonizeGraph.findIntersectionNodes((PolygonizeDirectedEdge)var2_2, var3_3)) == null) continue;
            var2_2 = var2_2.iterator();
            while (true) {
                if (var2_2.hasNext()) ** break;
                continue block0;
                PolygonizeGraph.computeNextCCWEdges((Node)var2_2.next(), var3_3);
            }
            break;
        }
    }

    public static void deleteAllEdges(Node object) {
        object = ((Node)object).getOutEdges().getEdges().iterator();
        while (object.hasNext()) {
            PolygonizeDirectedEdge polygonizeDirectedEdge = (PolygonizeDirectedEdge)object.next();
            polygonizeDirectedEdge.setMarked(true);
            if ((polygonizeDirectedEdge = (PolygonizeDirectedEdge)polygonizeDirectedEdge.getSym()) == null) continue;
            polygonizeDirectedEdge.setMarked(true);
        }
        return;
    }

    private EdgeRing findEdgeRing(PolygonizeDirectedEdge polygonizeDirectedEdge) {
        EdgeRing edgeRing = new EdgeRing(this.factory);
        edgeRing.build(polygonizeDirectedEdge);
        return edgeRing;
    }

    private static List findIntersectionNodes(PolygonizeDirectedEdge polygonizeDirectedEdge, long l) {
        ArrayList<GraphComponent> arrayList;
        GraphComponent graphComponent;
        ArrayList<GraphComponent> arrayList2 = null;
        GraphComponent graphComponent2 = polygonizeDirectedEdge;
        do {
            graphComponent = graphComponent2.getFromNode();
            int n = PolygonizeGraph.getDegree((Node)graphComponent, l);
            boolean bl = true;
            arrayList = arrayList2;
            if (n > 1) {
                arrayList = arrayList2;
                if (arrayList2 == null) {
                    arrayList = new ArrayList<GraphComponent>();
                }
                arrayList.add(graphComponent);
            }
            boolean bl2 = (graphComponent = graphComponent2.getNext()) != null;
            Assert.isTrue(bl2, "found null DE in ring");
            bl2 = bl;
            if (graphComponent != polygonizeDirectedEdge) {
                bl2 = bl;
                if (((PolygonizeDirectedEdge)graphComponent).isInRing()) {
                    bl2 = false;
                }
            }
            Assert.isTrue(bl2, "found DE already in ring");
            arrayList2 = arrayList;
            graphComponent2 = graphComponent;
        } while (graphComponent != polygonizeDirectedEdge);
        return arrayList;
    }

    private static List findLabeledEdgeRings(Collection object) {
        ArrayList<PolygonizeDirectedEdge> arrayList = new ArrayList<PolygonizeDirectedEdge>();
        object = object.iterator();
        long l = 1L;
        while (object.hasNext()) {
            PolygonizeDirectedEdge polygonizeDirectedEdge = (PolygonizeDirectedEdge)object.next();
            if (polygonizeDirectedEdge.isMarked() || polygonizeDirectedEdge.getLabel() >= 0L) continue;
            arrayList.add(polygonizeDirectedEdge);
            PolygonizeGraph.label(EdgeRing.findDirEdgesInRing(polygonizeDirectedEdge), l);
            ++l;
        }
        return arrayList;
    }

    private static int getDegree(Node object, long l) {
        object = ((Node)object).getOutEdges().getEdges().iterator();
        int n = 0;
        while (object.hasNext()) {
            if (((PolygonizeDirectedEdge)object.next()).getLabel() != l) continue;
            ++n;
        }
        return n;
    }

    private static int getDegreeNonDeleted(Node object) {
        object = ((Node)object).getOutEdges().getEdges().iterator();
        int n = 0;
        while (object.hasNext()) {
            if (((PolygonizeDirectedEdge)object.next()).isMarked()) continue;
            ++n;
        }
        return n;
    }

    private Node getNode(Coordinate coordinate) {
        Node node;
        Node node2 = node = this.findNode(coordinate);
        if (node == null) {
            node2 = new Node(coordinate);
            this.add(node2);
        }
        return node2;
    }

    private static void label(Collection object, long l) {
        object = object.iterator();
        while (object.hasNext()) {
            ((PolygonizeDirectedEdge)object.next()).setLabel(l);
        }
        return;
    }

    public void addEdge(LineString object) {
        if (((LineString)object).isEmpty()) {
            return;
        }
        Object object2 = CoordinateArrays.removeRepeatedPoints(((LineString)object).getCoordinates());
        if (((Coordinate[])object2).length < 2) {
            return;
        }
        Object object3 = object2[0];
        Comparable comparable = object2[((Coordinate[])object2).length - 1];
        object3 = this.getNode((Coordinate)object3);
        Node node = this.getNode((Coordinate)comparable);
        comparable = new PolygonizeDirectedEdge((Node)object3, node, object2[1], true);
        object2 = new PolygonizeDirectedEdge(node, (Node)object3, object2[((Coordinate[])object2).length - 2], false);
        object = new PolygonizeEdge((LineString)object);
        ((Edge)object).setDirectedEdges((DirectedEdge)comparable, (DirectedEdge)object2);
        this.add((Edge)object);
    }

    public void computeDepthParity() {
    }

    public List deleteCutEdges() {
        this.computeNextCWEdges();
        PolygonizeGraph.findLabeledEdgeRings(this.dirEdges);
        ArrayList<LineString> arrayList = new ArrayList<LineString>();
        Iterator iterator2 = this.dirEdges.iterator();
        while (iterator2.hasNext()) {
            PolygonizeDirectedEdge polygonizeDirectedEdge = (PolygonizeDirectedEdge)iterator2.next();
            if (polygonizeDirectedEdge.isMarked()) continue;
            PolygonizeDirectedEdge polygonizeDirectedEdge2 = (PolygonizeDirectedEdge)polygonizeDirectedEdge.getSym();
            if (polygonizeDirectedEdge.getLabel() != polygonizeDirectedEdge2.getLabel()) continue;
            polygonizeDirectedEdge.setMarked(true);
            polygonizeDirectedEdge2.setMarked(true);
            arrayList.add(((PolygonizeEdge)polygonizeDirectedEdge.getEdge()).getLine());
        }
        return arrayList;
    }

    public Collection deleteDangles() {
        Iterator iterator2 = this.findNodesOfDegree(1);
        HashSet<LineString> hashSet = new HashSet<LineString>();
        Stack<PolygonizeDirectedEdge> stack = new Stack<PolygonizeDirectedEdge>();
        iterator2 = iterator2.iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                block1: while (true) {
                    if (stack.isEmpty()) {
                        return hashSet;
                    }
                    iterator2 = (Node)stack.pop();
                    PolygonizeGraph.deleteAllEdges((Node)((Object)iterator2));
                    iterator2 = ((Node)((Object)iterator2)).getOutEdges().getEdges().iterator();
                    while (true) {
                        if (!iterator2.hasNext()) continue block1;
                        PolygonizeDirectedEdge polygonizeDirectedEdge = (PolygonizeDirectedEdge)iterator2.next();
                        polygonizeDirectedEdge.setMarked(true);
                        GraphComponent graphComponent = (PolygonizeDirectedEdge)polygonizeDirectedEdge.getSym();
                        if (graphComponent != null) {
                            graphComponent.setMarked(true);
                        }
                        hashSet.add(((PolygonizeEdge)polygonizeDirectedEdge.getEdge()).getLine());
                        graphComponent = polygonizeDirectedEdge.getToNode();
                        if (PolygonizeGraph.getDegreeNonDeleted((Node)graphComponent) != 1) continue;
                        stack.push((PolygonizeDirectedEdge)graphComponent);
                    }
                    break;
                }
            }
            stack.push((PolygonizeDirectedEdge)iterator2.next());
        }
    }

    public List getEdgeRings() {
        this.computeNextCWEdges();
        PolygonizeGraph.label(this.dirEdges, -1L);
        this.convertMaximalToMinimalEdgeRings(PolygonizeGraph.findLabeledEdgeRings(this.dirEdges));
        ArrayList<EdgeRing> arrayList = new ArrayList<EdgeRing>();
        Iterator iterator2 = this.dirEdges.iterator();
        while (iterator2.hasNext()) {
            PolygonizeDirectedEdge polygonizeDirectedEdge = (PolygonizeDirectedEdge)iterator2.next();
            if (polygonizeDirectedEdge.isMarked() || polygonizeDirectedEdge.isInRing()) continue;
            arrayList.add(this.findEdgeRing(polygonizeDirectedEdge));
        }
        return arrayList;
    }
}

