/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.polygonize;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.polygonize.EdgeRing;
import com.vividsolutions.jts.operation.polygonize.PolygonizeGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Polygonizer {
    protected List cutEdges;
    protected Collection dangles;
    private boolean extractOnlyPolygonal;
    private GeometryFactory geomFactory = null;
    protected PolygonizeGraph graph;
    protected List holeList = null;
    protected List invalidRingLines;
    private boolean isCheckingRingsValid = true;
    private LineStringAdder lineStringAdder = new LineStringAdder();
    protected List polyList = null;
    protected List shellList = null;

    public Polygonizer() {
        this(false);
    }

    public Polygonizer(boolean bl) {
        this.dangles = new ArrayList();
        this.cutEdges = new ArrayList();
        this.invalidRingLines = new ArrayList();
        this.extractOnlyPolygonal = bl;
    }

    private void add(LineString lineString) {
        GeometryFactory geometryFactory;
        this.geomFactory = geometryFactory = lineString.getFactory();
        if (this.graph == null) {
            this.graph = new PolygonizeGraph(geometryFactory);
        }
        this.graph.addEdge(lineString);
    }

    private static void assignHoleToShell(EdgeRing edgeRing, List object) {
        if ((object = EdgeRing.findEdgeRingContaining(edgeRing, (List)object)) != null) {
            ((EdgeRing)object).addHole(edgeRing);
        }
    }

    private static void assignHolesToShells(List object, List list) {
        object = object.iterator();
        while (object.hasNext()) {
            Polygonizer.assignHoleToShell((EdgeRing)object.next(), list);
        }
        return;
    }

    private static List extractPolygons(List object, boolean bl) {
        ArrayList<Polygon> arrayList = new ArrayList<Polygon>();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = (EdgeRing)iterator2.next();
            if (!bl && !((EdgeRing)object).isIncluded()) continue;
            arrayList.add(((EdgeRing)object).getPolygon());
        }
        return arrayList;
    }

    private static void findDisjointShells(List list) {
        Polygonizer.findOuterShells(list);
        block0: while (true) {
            boolean bl = false;
            Iterator iterator2 = list.iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    if (bl) continue block0;
                    return;
                }
                EdgeRing edgeRing = (EdgeRing)iterator2.next();
                if (edgeRing.isIncludedSet()) continue;
                edgeRing.updateIncluded();
                if (edgeRing.isIncludedSet()) continue;
                bl = true;
            }
            break;
        }
    }

    private static void findOuterShells(List object) {
        object = object.iterator();
        while (object.hasNext()) {
            EdgeRing edgeRing = (EdgeRing)object.next();
            EdgeRing edgeRing2 = edgeRing.getOuterHole();
            if (edgeRing2 == null || edgeRing2.isProcessed()) continue;
            edgeRing.setIncluded(true);
            edgeRing2.setProcessed(true);
        }
        return;
    }

    private void findShellsAndHoles(List object) {
        this.holeList = new ArrayList();
        this.shellList = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            EdgeRing edgeRing = (EdgeRing)object.next();
            edgeRing.computeHole();
            if (edgeRing.isHole()) {
                this.holeList.add(edgeRing);
                continue;
            }
            this.shellList.add(edgeRing);
        }
        return;
    }

    private void findValidRings(List object, List list, List list2) {
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = (EdgeRing)iterator2.next();
            if (((EdgeRing)object).isValid()) {
                list.add(object);
                continue;
            }
            list2.add(((EdgeRing)object).getLineString());
        }
        return;
    }

    private void polygonize() {
        ArrayList arrayList;
        if (this.polyList != null) {
            return;
        }
        this.polyList = new ArrayList();
        Object object = this.graph;
        if (object == null) {
            return;
        }
        this.dangles = ((PolygonizeGraph)object).deleteDangles();
        this.cutEdges = this.graph.deleteCutEdges();
        List list = this.graph.getEdgeRings();
        ArrayList arrayList2 = new ArrayList();
        this.invalidRingLines = arrayList = new ArrayList();
        object = list;
        if (this.isCheckingRingsValid) {
            this.findValidRings(list, arrayList2, arrayList);
            object = arrayList2;
        }
        this.findShellsAndHoles((List)object);
        Polygonizer.assignHolesToShells(this.holeList, this.shellList);
        Collections.sort(this.shellList, new EdgeRing.EnvelopeComparator());
        boolean bl = true;
        if (this.extractOnlyPolygonal) {
            Polygonizer.findDisjointShells(this.shellList);
            bl = false;
        }
        this.polyList = Polygonizer.extractPolygons(this.shellList, bl);
    }

    public void add(Geometry geometry) {
        geometry.apply(this.lineStringAdder);
    }

    public void add(Collection object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.add((Geometry)object.next());
        }
        return;
    }

    public Collection getCutEdges() {
        this.polygonize();
        return this.cutEdges;
    }

    public Collection getDangles() {
        this.polygonize();
        return this.dangles;
    }

    public Geometry getGeometry() {
        if (this.geomFactory == null) {
            this.geomFactory = new GeometryFactory();
        }
        this.polygonize();
        if (this.extractOnlyPolygonal) {
            return this.geomFactory.buildGeometry(this.polyList);
        }
        return this.geomFactory.createGeometryCollection(GeometryFactory.toGeometryArray(this.polyList));
    }

    public Collection getInvalidRingLines() {
        this.polygonize();
        return this.invalidRingLines;
    }

    public Collection getPolygons() {
        this.polygonize();
        return this.polyList;
    }

    public void setCheckRingsValid(boolean bl) {
        this.isCheckingRingsValid = bl;
    }

    private class LineStringAdder
    implements GeometryComponentFilter {
        private LineStringAdder() {
        }

        @Override
        public void filter(Geometry geometry) {
            if (geometry instanceof LineString) {
                Polygonizer.this.add((LineString)geometry);
            }
        }
    }
}

