/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.predicate;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.ShortCircuitedGeometryVisitor;
import com.vividsolutions.jts.operation.predicate.EnvelopeIntersectsVisitor;
import com.vividsolutions.jts.operation.predicate.GeometryContainsPointVisitor;
import com.vividsolutions.jts.operation.predicate.RectangleIntersectsSegmentVisitor;

public class RectangleIntersects {
    private Envelope rectEnv;
    private Polygon rectangle;

    public RectangleIntersects(Polygon polygon) {
        this.rectangle = polygon;
        this.rectEnv = polygon.getEnvelopeInternal();
    }

    public static boolean intersects(Polygon polygon, Geometry geometry) {
        return new RectangleIntersects(polygon).intersects(geometry);
    }

    public boolean intersects(Geometry geometry) {
        if (!this.rectEnv.intersects(geometry.getEnvelopeInternal())) {
            return false;
        }
        ShortCircuitedGeometryVisitor shortCircuitedGeometryVisitor = new EnvelopeIntersectsVisitor(this.rectEnv);
        shortCircuitedGeometryVisitor.applyTo(geometry);
        if (((EnvelopeIntersectsVisitor)shortCircuitedGeometryVisitor).intersects()) {
            return true;
        }
        shortCircuitedGeometryVisitor = new GeometryContainsPointVisitor(this.rectangle);
        shortCircuitedGeometryVisitor.applyTo(geometry);
        if (((GeometryContainsPointVisitor)shortCircuitedGeometryVisitor).containsPoint()) {
            return true;
        }
        shortCircuitedGeometryVisitor = new RectangleIntersectsSegmentVisitor(this.rectangle);
        shortCircuitedGeometryVisitor.applyTo(geometry);
        return ((RectangleIntersectsSegmentVisitor)shortCircuitedGeometryVisitor).intersects();
    }
}

