/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.relate;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.GraphComponent;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.NodeMap;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import com.vividsolutions.jts.operation.relate.EdgeEndBuilder;
import com.vividsolutions.jts.operation.relate.RelateNode;
import com.vividsolutions.jts.operation.relate.RelateNodeFactory;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RelateComputer {
    private GeometryGraph[] arg;
    private IntersectionMatrix im = null;
    private Coordinate invalidPoint;
    private ArrayList isolatedEdges;
    private LineIntersector li = new RobustLineIntersector();
    private NodeMap nodes;
    private PointLocator ptLocator = new PointLocator();

    public RelateComputer(GeometryGraph[] geometryGraphArray) {
        this.nodes = new NodeMap(new RelateNodeFactory());
        this.isolatedEdges = new ArrayList();
        this.arg = geometryGraphArray;
    }

    private void computeDisjointIM(IntersectionMatrix intersectionMatrix) {
        Geometry geometry = this.arg[0].getGeometry();
        if (!geometry.isEmpty()) {
            intersectionMatrix.set(0, 2, geometry.getDimension());
            intersectionMatrix.set(1, 2, geometry.getBoundaryDimension());
        }
        if (!(geometry = this.arg[1].getGeometry()).isEmpty()) {
            intersectionMatrix.set(2, 0, geometry.getDimension());
            intersectionMatrix.set(2, 1, geometry.getBoundaryDimension());
        }
    }

    private void computeIntersectionNodes(int n) {
        Iterator iterator2 = this.arg[n].getEdgeIterator();
        block0: while (iterator2.hasNext()) {
            Object object = (Edge)iterator2.next();
            int n2 = ((GraphComponent)object).getLabel().getLocation(n);
            object = ((Edge)object).getEdgeIntersectionList().iterator();
            while (true) {
                if (!object.hasNext()) continue block0;
                Object object2 = (EdgeIntersection)object.next();
                object2 = (RelateNode)this.nodes.addNode(((EdgeIntersection)object2).coord);
                if (n2 == 1) {
                    ((Node)object2).setLabelBoundary(n);
                    continue;
                }
                if (!((GraphComponent)object2).getLabel().isNull(n)) continue;
                ((Node)object2).setLabel(n, 0);
            }
            break;
        }
        return;
    }

    private void computeProperIntersectionIM(SegmentIntersector segmentIntersector, IntersectionMatrix intersectionMatrix) {
        int n = this.arg[0].getGeometry().getDimension();
        int n2 = this.arg[1].getGeometry().getDimension();
        boolean bl = segmentIntersector.hasProperIntersection();
        boolean bl2 = segmentIntersector.hasProperInteriorIntersection();
        if (n == 2 && n2 == 2) {
            if (bl) {
                intersectionMatrix.setAtLeast("212101212");
            }
        } else if (n == 2 && n2 == 1) {
            if (bl) {
                intersectionMatrix.setAtLeast("FFF0FFFF2");
            }
            if (bl2) {
                intersectionMatrix.setAtLeast("1FFFFF1FF");
            }
        } else if (n == 1 && n2 == 2) {
            if (bl) {
                intersectionMatrix.setAtLeast("F0FFFFFF2");
            }
            if (bl2) {
                intersectionMatrix.setAtLeast("1F1FFFFFF");
            }
        } else if (n == 1 && n2 == 1 && bl2) {
            intersectionMatrix.setAtLeast("0FFFFFFFF");
        }
    }

    private void copyNodesAndLabels(int n) {
        Iterator iterator2 = this.arg[n].getNodeIterator();
        while (iterator2.hasNext()) {
            Node node = (Node)iterator2.next();
            this.nodes.addNode(node.getCoordinate()).setLabel(n, node.getLabel().getLocation(n));
        }
        return;
    }

    private void insertEdgeEnds(List object) {
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = (EdgeEnd)iterator2.next();
            this.nodes.add((EdgeEnd)object);
        }
        return;
    }

    private void labelIntersectionNodes(int n) {
        Iterator iterator2 = this.arg[n].getEdgeIterator();
        block0: while (iterator2.hasNext()) {
            Object object = (Edge)iterator2.next();
            int n2 = ((GraphComponent)object).getLabel().getLocation(n);
            object = ((Edge)object).getEdgeIntersectionList().iterator();
            while (true) {
                if (!object.hasNext()) continue block0;
                Object object2 = (EdgeIntersection)object.next();
                object2 = (RelateNode)this.nodes.find(((EdgeIntersection)object2).coord);
                if (!((GraphComponent)object2).getLabel().isNull(n)) continue;
                if (n2 == 1) {
                    ((Node)object2).setLabelBoundary(n);
                    continue;
                }
                ((Node)object2).setLabel(n, 0);
            }
            break;
        }
        return;
    }

    private void labelIsolatedEdge(Edge edge, int n, Geometry geometry) {
        if (geometry.getDimension() > 0) {
            int n2 = this.ptLocator.locate(edge.getCoordinate(), geometry);
            edge.getLabel().setAllLocations(n, n2);
        } else {
            edge.getLabel().setAllLocations(n, 2);
        }
    }

    private void labelIsolatedEdges(int n, int n2) {
        Iterator iterator2 = this.arg[n].getEdgeIterator();
        while (iterator2.hasNext()) {
            Edge edge = (Edge)iterator2.next();
            if (!edge.isIsolated()) continue;
            this.labelIsolatedEdge(edge, n2, this.arg[n2].getGeometry());
            this.isolatedEdges.add(edge);
        }
        return;
    }

    private void labelIsolatedNode(Node node, int n) {
        int n2 = this.ptLocator.locate(node.getCoordinate(), this.arg[n].getGeometry());
        node.getLabel().setAllLocations(n, n2);
    }

    private void labelIsolatedNodes() {
        Iterator iterator2 = this.nodes.iterator();
        while (iterator2.hasNext()) {
            Node node = (Node)iterator2.next();
            Label label = node.getLabel();
            boolean bl = label.getGeometryCount() > 0;
            Assert.isTrue(bl, "node with empty label found");
            if (!node.isIsolated()) continue;
            if (label.isNull(0)) {
                this.labelIsolatedNode(node, 0);
                continue;
            }
            this.labelIsolatedNode(node, 1);
        }
        return;
    }

    private void labelNodeEdges() {
        Iterator iterator2 = this.nodes.iterator();
        while (iterator2.hasNext()) {
            ((RelateNode)iterator2.next()).getEdges().computeLabelling(this.arg);
        }
        return;
    }

    private void updateIM(IntersectionMatrix intersectionMatrix) {
        Iterator iterator2 = this.isolatedEdges.iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                iterator2 = this.nodes.iterator();
                while (true) {
                    if (!iterator2.hasNext()) {
                        return;
                    }
                    RelateNode relateNode = (RelateNode)iterator2.next();
                    relateNode.updateIM(intersectionMatrix);
                    relateNode.updateIMFromEdges(intersectionMatrix);
                }
            }
            ((Edge)iterator2.next()).updateIM(intersectionMatrix);
        }
    }

    public IntersectionMatrix computeIM() {
        IntersectionMatrix intersectionMatrix = new IntersectionMatrix();
        intersectionMatrix.set(2, 2, 2);
        if (!this.arg[0].getGeometry().getEnvelopeInternal().intersects(this.arg[1].getGeometry().getEnvelopeInternal())) {
            this.computeDisjointIM(intersectionMatrix);
            return intersectionMatrix;
        }
        this.arg[0].computeSelfNodes(this.li, false);
        this.arg[1].computeSelfNodes(this.li, false);
        Object object = this.arg;
        object = object[0].computeEdgeIntersections(object[1], this.li, false);
        this.computeIntersectionNodes(0);
        this.computeIntersectionNodes(1);
        this.copyNodesAndLabels(0);
        this.copyNodesAndLabels(1);
        this.labelIsolatedNodes();
        this.computeProperIntersectionIM((SegmentIntersector)object, intersectionMatrix);
        object = new EdgeEndBuilder();
        this.insertEdgeEnds(((EdgeEndBuilder)object).computeEdgeEnds(this.arg[0].getEdgeIterator()));
        this.insertEdgeEnds(((EdgeEndBuilder)object).computeEdgeEnds(this.arg[1].getEdgeIterator()));
        this.labelNodeEdges();
        this.labelIsolatedEdges(0, 1);
        this.labelIsolatedEdges(1, 0);
        this.updateIM(intersectionMatrix);
        return intersectionMatrix;
    }
}

