/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.relate;

import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.GraphComponent;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.NodeMap;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.operation.relate.EdgeEndBuilder;
import com.vividsolutions.jts.operation.relate.RelateNode;
import com.vividsolutions.jts.operation.relate.RelateNodeFactory;
import java.util.Iterator;
import java.util.List;

public class RelateNodeGraph {
    private NodeMap nodes = new NodeMap(new RelateNodeFactory());

    public void build(GeometryGraph geometryGraph) {
        this.computeIntersectionNodes(geometryGraph, 0);
        this.copyNodesAndLabels(geometryGraph, 0);
        this.insertEdgeEnds(new EdgeEndBuilder().computeEdgeEnds(geometryGraph.getEdgeIterator()));
    }

    public void computeIntersectionNodes(GeometryGraph object, int n) {
        object = ((PlanarGraph)object).getEdgeIterator();
        block0: while (object.hasNext()) {
            Object object2 = (Edge)object.next();
            int n2 = ((GraphComponent)object2).getLabel().getLocation(n);
            object2 = ((Edge)object2).getEdgeIntersectionList().iterator();
            while (true) {
                if (!object2.hasNext()) continue block0;
                Object object3 = (EdgeIntersection)object2.next();
                object3 = (RelateNode)this.nodes.addNode(((EdgeIntersection)object3).coord);
                if (n2 == 1) {
                    ((Node)object3).setLabelBoundary(n);
                    continue;
                }
                if (!((GraphComponent)object3).getLabel().isNull(n)) continue;
                ((Node)object3).setLabel(n, 0);
            }
            break;
        }
        return;
    }

    public void copyNodesAndLabels(GeometryGraph object, int n) {
        Iterator iterator2 = ((PlanarGraph)object).getNodeIterator();
        while (iterator2.hasNext()) {
            object = (Node)iterator2.next();
            this.nodes.addNode(((Node)object).getCoordinate()).setLabel(n, ((GraphComponent)object).getLabel().getLocation(n));
        }
        return;
    }

    public Iterator getNodeIterator() {
        return this.nodes.iterator();
    }

    public void insertEdgeEnds(List object) {
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = (EdgeEnd)iterator2.next();
            this.nodes.add((EdgeEnd)object);
        }
        return;
    }
}

