/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.union;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Puntal;
import com.vividsolutions.jts.geom.util.GeometryExtracter;
import com.vividsolutions.jts.operation.overlay.snap.SnapIfNeededOverlayOp;
import com.vividsolutions.jts.operation.union.CascadedPolygonUnion;
import com.vividsolutions.jts.operation.union.PointGeometryUnion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UnaryUnionOp {
    private GeometryFactory geomFact = null;
    private List lines;
    private List points;
    private List polygons = new ArrayList();

    public UnaryUnionOp(Geometry geometry) {
        this.lines = new ArrayList();
        this.points = new ArrayList();
        this.extract(geometry);
    }

    public UnaryUnionOp(Collection collection) {
        this.lines = new ArrayList();
        this.points = new ArrayList();
        this.extract(collection);
    }

    public UnaryUnionOp(Collection collection, GeometryFactory geometryFactory) {
        this.lines = new ArrayList();
        this.points = new ArrayList();
        this.geomFact = geometryFactory;
        this.extract(collection);
    }

    private void extract(Geometry geometry) {
        if (this.geomFact == null) {
            this.geomFact = geometry.getFactory();
        }
        GeometryExtracter.extract(geometry, Polygon.class, this.polygons);
        GeometryExtracter.extract(geometry, LineString.class, this.lines);
        GeometryExtracter.extract(geometry, Point.class, this.points);
    }

    private void extract(Collection object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.extract((Geometry)object.next());
        }
        return;
    }

    public static Geometry union(Geometry geometry) {
        return new UnaryUnionOp(geometry).union();
    }

    public static Geometry union(Collection collection) {
        return new UnaryUnionOp(collection).union();
    }

    public static Geometry union(Collection collection, GeometryFactory geometryFactory) {
        return new UnaryUnionOp(collection, geometryFactory).union();
    }

    private Geometry unionNoOpt(Geometry geometry) {
        return SnapIfNeededOverlayOp.overlayOp(geometry, this.geomFact.createPoint((Coordinate)null), 2);
    }

    private Geometry unionWithNull(Geometry geometry, Geometry geometry2) {
        if (geometry == null && geometry2 == null) {
            return null;
        }
        if (geometry2 == null) {
            return geometry;
        }
        if (geometry == null) {
            return geometry2;
        }
        return geometry.union(geometry2);
    }

    public Geometry union() {
        if (this.geomFact == null) {
            return null;
        }
        Geometry geometry = this.points.size() > 0 ? this.unionNoOpt(this.geomFact.buildGeometry(this.points)) : null;
        Geometry geometry2 = this.lines.size() > 0 ? this.unionNoOpt(this.geomFact.buildGeometry(this.lines)) : null;
        Geometry geometry3 = this.polygons.size() > 0 ? CascadedPolygonUnion.union(this.polygons) : null;
        geometry2 = this.unionWithNull(geometry2, geometry3);
        if (geometry == null) {
            geometry = geometry2;
        } else if (geometry2 != null) {
            geometry = PointGeometryUnion.union((Puntal)((Object)geometry), geometry2);
        }
        geometry2 = geometry;
        if (geometry == null) {
            geometry2 = this.geomFact.createGeometryCollection(null);
        }
        return geometry2;
    }
}

