/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.operation.overlay.MaximalEdgeRing;
import com.vividsolutions.jts.operation.overlay.OverlayNodeFactory;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ConnectedInteriorTester {
    private Coordinate disconnectedRingcoord;
    private GeometryGraph geomGraph;
    private GeometryFactory geometryFactory = new GeometryFactory();

    public ConnectedInteriorTester(GeometryGraph geometryGraph) {
        this.geomGraph = geometryGraph;
    }

    private List buildEdgeRings(Collection object) {
        ArrayList arrayList = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (DirectedEdge)object.next();
            if (!((DirectedEdge)object2).isInResult() || ((DirectedEdge)object2).getEdgeRing() != null) continue;
            object2 = new MaximalEdgeRing((DirectedEdge)object2, this.geometryFactory);
            ((MaximalEdgeRing)object2).linkDirectedEdgesForMinimalEdgeRings();
            arrayList.addAll(((MaximalEdgeRing)object2).buildMinimalRings());
        }
        return arrayList;
    }

    public static Coordinate findDifferentPoint(Coordinate[] coordinateArray, Coordinate coordinate) {
        int n = 0;
        while (n < coordinateArray.length) {
            if (!coordinateArray[n].equals(coordinate)) {
                return coordinateArray[n];
            }
            ++n;
        }
        return null;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private boolean hasUnvisitedShellEdge(List list) {
        int n = 0;
        block0: while (n < list.size()) {
            boolean bl = true;
            while (true) {
                int n2;
                List list2;
                Object object;
                block9: {
                    block8: {
                        block7: {
                            if (!bl || (bl = false)) break block7;
                            object = (EdgeRing)list.get(n);
                            if (((EdgeRing)object).isHole() || ((DirectedEdge)(list2 = ((EdgeRing)object).getEdges()).get(0)).getLabel().getLocation(0, 2) != 0) break block8;
                            n2 = 0;
                        }
                        if (n2 < list2.size()) break block9;
                    }
                    ++n;
                    continue block0;
                }
                object = (DirectedEdge)list2.get(n2);
                if (!((DirectedEdge)object).isVisited()) {
                    this.disconnectedRingcoord = ((EdgeEnd)object).getCoordinate();
                    return true;
                }
                ++n2;
            }
            break;
        }
        return false;
    }

    private void setInteriorEdgesInResult(PlanarGraph object) {
        Iterator iterator2 = ((PlanarGraph)object).getEdgeEnds().iterator();
        while (iterator2.hasNext()) {
            object = (DirectedEdge)iterator2.next();
            if (((EdgeEnd)object).getLabel().getLocation(0, 2) != 0) continue;
            ((DirectedEdge)object).setInResult(true);
        }
        return;
    }

    private void visitInteriorRing(LineString object, PlanarGraph planarGraph) {
        object = ((LineString)object).getCoordinates();
        boolean bl = false;
        Coordinate coordinate = object[0];
        if (((EdgeEnd)(object = (DirectedEdge)planarGraph.findEdgeEnd(planarGraph.findEdgeInSameDirection(coordinate, ConnectedInteriorTester.findDifferentPoint((Coordinate[])object, coordinate))))).getLabel().getLocation(0, 2) != 0) {
            object = ((DirectedEdge)object).getSym().getLabel().getLocation(0, 2) == 0 ? ((DirectedEdge)object).getSym() : null;
        }
        if (object != null) {
            bl = true;
        }
        Assert.isTrue(bl, "unable to find dirEdge with Interior on RHS");
        this.visitLinkedDirectedEdges((DirectedEdge)object);
    }

    private void visitShellInteriors(Geometry geometry, PlanarGraph planarGraph) {
        if (geometry instanceof Polygon) {
            this.visitInteriorRing(((Polygon)geometry).getExteriorRing(), planarGraph);
        }
        if (geometry instanceof MultiPolygon) {
            geometry = (MultiPolygon)geometry;
            for (int i = 0; i < ((GeometryCollection)geometry).getNumGeometries(); ++i) {
                this.visitInteriorRing(((Polygon)((GeometryCollection)geometry).getGeometryN(i)).getExteriorRing(), planarGraph);
            }
        }
    }

    public Coordinate getCoordinate() {
        return this.disconnectedRingcoord;
    }

    public boolean isInteriorsConnected() {
        List list = new ArrayList();
        this.geomGraph.computeSplitEdges(list);
        PlanarGraph planarGraph = new PlanarGraph(new OverlayNodeFactory());
        planarGraph.addEdges(list);
        this.setInteriorEdgesInResult(planarGraph);
        planarGraph.linkResultDirectedEdges();
        list = this.buildEdgeRings(planarGraph.getEdgeEnds());
        this.visitShellInteriors(this.geomGraph.getGeometry(), planarGraph);
        return this.hasUnvisitedShellEdge(list) ^ true;
    }

    protected void visitLinkedDirectedEdges(DirectedEdge directedEdge) {
        DirectedEdge directedEdge2;
        DirectedEdge directedEdge3 = directedEdge;
        do {
            boolean bl = directedEdge3 != null;
            Assert.isTrue(bl, "found null Directed Edge");
            directedEdge3.setVisited(true);
            directedEdge3 = directedEdge2 = directedEdge3.getNext();
        } while (directedEdge2 != directedEdge);
    }
}

