/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import com.vividsolutions.jts.operation.relate.EdgeEndBundle;
import com.vividsolutions.jts.operation.relate.RelateNode;
import com.vividsolutions.jts.operation.relate.RelateNodeGraph;
import java.util.Iterator;

public class ConsistentAreaTester {
    private GeometryGraph geomGraph;
    private Coordinate invalidPoint;
    private final LineIntersector li = new RobustLineIntersector();
    private RelateNodeGraph nodeGraph = new RelateNodeGraph();

    public ConsistentAreaTester(GeometryGraph geometryGraph) {
        this.geomGraph = geometryGraph;
    }

    private boolean isNodeEdgeAreaLabelsConsistent() {
        RelateNode relateNode;
        Iterator iterator2 = this.nodeGraph.getNodeIterator();
        do {
            if (iterator2.hasNext()) continue;
            return true;
        } while ((relateNode = (RelateNode)iterator2.next()).getEdges().isAreaLabelsConsistent(this.geomGraph));
        this.invalidPoint = (Coordinate)relateNode.getCoordinate().clone();
        return false;
    }

    public Coordinate getInvalidPoint() {
        return this.invalidPoint;
    }

    public boolean hasDuplicateRings() {
        EdgeEndBundle edgeEndBundle;
        Iterator iterator2 = this.nodeGraph.getNodeIterator();
        block0: while (true) {
            if (!iterator2.hasNext()) {
                return false;
            }
            Iterator iterator3 = ((RelateNode)iterator2.next()).getEdges().iterator();
            do {
                if (!iterator3.hasNext()) continue block0;
            } while ((edgeEndBundle = (EdgeEndBundle)iterator3.next()).getEdgeEnds().size() <= 1);
            break;
        }
        this.invalidPoint = edgeEndBundle.getEdge().getCoordinate(0);
        return true;
    }

    public boolean isNodeConsistentArea() {
        SegmentIntersector segmentIntersector = this.geomGraph.computeSelfNodes(this.li, true);
        if (segmentIntersector.hasProperIntersection()) {
            this.invalidPoint = segmentIntersector.getProperIntersectionPoint();
            return false;
        }
        this.nodeGraph.build(this.geomGraph);
        return this.isNodeEdgeAreaLabelsConsistent();
    }
}

