/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import java.util.ArrayList;
import java.util.List;

public class IndexedNestedRingTester {
    private GeometryGraph graph;
    private SpatialIndex index;
    private Coordinate nestedPt;
    private List rings = new ArrayList();
    private Envelope totalEnv = new Envelope();

    public IndexedNestedRingTester(GeometryGraph geometryGraph) {
        this.graph = geometryGraph;
    }

    private void buildIndex() {
        this.index = new STRtree();
        int n = 0;
        while (n < this.rings.size()) {
            LinearRing linearRing = (LinearRing)this.rings.get(n);
            Envelope envelope = linearRing.getEnvelopeInternal();
            this.index.insert(envelope, linearRing);
            ++n;
        }
        return;
    }

    public void add(LinearRing linearRing) {
        this.rings.add(linearRing);
        this.totalEnv.expandToInclude(linearRing.getEnvelopeInternal());
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public boolean isNonNested() {
        this.buildIndex();
        int n = 0;
        block0: while (n < this.rings.size()) {
            LinearRing linearRing = (LinearRing)this.rings.get(n);
            Coordinate[] coordinateArray = linearRing.getCoordinates();
            List list = this.index.query(linearRing.getEnvelopeInternal());
            int n2 = 0;
            while (true) {
                if (n2 >= list.size()) {
                    ++n;
                    continue block0;
                }
                Cloneable cloneable = (LinearRing)list.get(n2);
                Coordinate[] coordinateArray2 = cloneable.getCoordinates();
                if (linearRing != cloneable && linearRing.getEnvelopeInternal().intersects(cloneable.getEnvelopeInternal()) && (cloneable = IsValidOp.findPtNotNode(coordinateArray, cloneable, this.graph)) != null && CGAlgorithms.isPointInRing((Coordinate)cloneable, coordinateArray2)) {
                    this.nestedPt = cloneable;
                    return false;
                }
                ++n2;
            }
            break;
        }
        return true;
    }
}

