/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class SimpleNestedRingTester {
    private GeometryGraph graph;
    private Coordinate nestedPt;
    private List rings = new ArrayList();

    public SimpleNestedRingTester(GeometryGraph geometryGraph) {
        this.graph = geometryGraph;
    }

    public void add(LinearRing linearRing) {
        this.rings.add(linearRing);
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public boolean isNonNested() {
        int n = 0;
        block0: while (n < this.rings.size()) {
            LinearRing linearRing = (LinearRing)this.rings.get(n);
            Coordinate[] coordinateArray = linearRing.getCoordinates();
            int n2 = 0;
            while (true) {
                if (n2 >= this.rings.size()) {
                    ++n;
                    continue block0;
                }
                Cloneable cloneable = (LinearRing)this.rings.get(n2);
                Coordinate[] coordinateArray2 = cloneable.getCoordinates();
                if (linearRing != cloneable && linearRing.getEnvelopeInternal().intersects(cloneable.getEnvelopeInternal())) {
                    boolean bl = (cloneable = IsValidOp.findPtNotNode(coordinateArray, cloneable, this.graph)) != null;
                    Assert.isTrue(bl, "Unable to find a ring point not a node of the search ring");
                    if (CGAlgorithms.isPointInRing((Coordinate)cloneable, coordinateArray2)) {
                        this.nestedPt = cloneable;
                        return false;
                    }
                }
                ++n2;
            }
            break;
        }
        return true;
    }
}

