/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.index.sweepline.SweepLineIndex;
import com.vividsolutions.jts.index.sweepline.SweepLineInterval;
import com.vividsolutions.jts.index.sweepline.SweepLineOverlapAction;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class SweeplineNestedRingTester {
    private GeometryGraph graph;
    private Coordinate nestedPt = null;
    private List rings = new ArrayList();
    private SweepLineIndex sweepLine;

    public SweeplineNestedRingTester(GeometryGraph geometryGraph) {
        this.graph = geometryGraph;
    }

    private void buildIndex() {
        this.sweepLine = new SweepLineIndex();
        int n = 0;
        while (n < this.rings.size()) {
            Object object = (LinearRing)this.rings.get(n);
            Envelope envelope = ((Geometry)object).getEnvelopeInternal();
            object = new SweepLineInterval(envelope.getMinX(), envelope.getMaxX(), object);
            this.sweepLine.add((SweepLineInterval)object);
            ++n;
        }
        return;
    }

    private boolean isInside(LinearRing cloneable, LinearRing linearRing) {
        Coordinate[] coordinateArray = cloneable.getCoordinates();
        Coordinate[] coordinateArray2 = linearRing.getCoordinates();
        if (!cloneable.getEnvelopeInternal().intersects(linearRing.getEnvelopeInternal())) {
            return false;
        }
        cloneable = IsValidOp.findPtNotNode(coordinateArray, linearRing, this.graph);
        boolean bl = cloneable != null;
        Assert.isTrue(bl, "Unable to find a ring point not a node of the search ring");
        if (CGAlgorithms.isPointInRing((Coordinate)cloneable, coordinateArray2)) {
            this.nestedPt = cloneable;
            return true;
        }
        return false;
    }

    public void add(LinearRing linearRing) {
        this.rings.add(linearRing);
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public boolean isNonNested() {
        this.buildIndex();
        OverlapAction overlapAction = new OverlapAction();
        this.sweepLine.computeOverlaps(overlapAction);
        return overlapAction.isNonNested;
    }

    class OverlapAction
    implements SweepLineOverlapAction {
        boolean isNonNested = true;

        OverlapAction() {
        }

        @Override
        public void overlap(SweepLineInterval object, SweepLineInterval object2) {
            if ((object = (LinearRing)((SweepLineInterval)object).getItem()) == (object2 = (LinearRing)((SweepLineInterval)object2).getItem())) {
                return;
            }
            if (SweeplineNestedRingTester.this.isInside((LinearRing)object, (LinearRing)object2)) {
                this.isNonNested = false;
            }
        }
    }
}

