/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.planargraph;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Quadrant;
import com.vividsolutions.jts.planargraph.Edge;
import com.vividsolutions.jts.planargraph.GraphComponent;
import com.vividsolutions.jts.planargraph.Node;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DirectedEdge
extends GraphComponent
implements Comparable {
    protected double angle;
    protected boolean edgeDirection;
    protected Node from;
    protected Coordinate p0;
    protected Coordinate p1;
    protected Edge parentEdge;
    protected int quadrant;
    protected DirectedEdge sym = null;
    protected Node to;

    public DirectedEdge(Node node, Node node2, Coordinate coordinate, boolean bl) {
        this.from = node;
        this.to = node2;
        this.edgeDirection = bl;
        this.p0 = node.getCoordinate();
        this.p1 = coordinate;
        double d = coordinate.x - this.p0.x;
        double d2 = this.p1.y - this.p0.y;
        this.quadrant = Quadrant.quadrant(d, d2);
        this.angle = Math.atan2(d2, d);
    }

    public static List toEdges(Collection object) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add(((DirectedEdge)object.next()).parentEdge);
        }
        return arrayList;
    }

    public int compareDirection(DirectedEdge directedEdge) {
        int n = this.quadrant;
        int n2 = directedEdge.quadrant;
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        return CGAlgorithms.computeOrientation(directedEdge.p0, directedEdge.p1, this.p1);
    }

    public int compareTo(Object object) {
        return this.compareDirection((DirectedEdge)object);
    }

    public double getAngle() {
        return this.angle;
    }

    public Coordinate getCoordinate() {
        return this.from.getCoordinate();
    }

    public Coordinate getDirectionPt() {
        return this.p1;
    }

    public Edge getEdge() {
        return this.parentEdge;
    }

    public boolean getEdgeDirection() {
        return this.edgeDirection;
    }

    public Node getFromNode() {
        return this.from;
    }

    public int getQuadrant() {
        return this.quadrant;
    }

    public DirectedEdge getSym() {
        return this.sym;
    }

    public Node getToNode() {
        return this.to;
    }

    @Override
    public boolean isRemoved() {
        return this.parentEdge == null;
    }

    public void print(PrintStream printStream) {
        CharSequence charSequence = this.getClass().getName();
        String string2 = ((String)charSequence).substring(((String)charSequence).lastIndexOf(46) + 1);
        charSequence = new StringBuilder("  ");
        ((StringBuilder)charSequence).append(string2);
        ((StringBuilder)charSequence).append(": ");
        ((StringBuilder)charSequence).append(this.p0);
        ((StringBuilder)charSequence).append(" - ");
        ((StringBuilder)charSequence).append(this.p1);
        ((StringBuilder)charSequence).append(" ");
        ((StringBuilder)charSequence).append(this.quadrant);
        ((StringBuilder)charSequence).append(":");
        ((StringBuilder)charSequence).append(this.angle);
        printStream.print(((StringBuilder)charSequence).toString());
    }

    void remove() {
        this.sym = null;
        this.parentEdge = null;
    }

    public void setEdge(Edge edge) {
        this.parentEdge = edge;
    }

    public void setSym(DirectedEdge directedEdge) {
        this.sym = directedEdge;
    }
}

