/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.planargraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.planargraph.DirectedEdge;
import com.vividsolutions.jts.planargraph.Edge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DirectedEdgeStar {
    protected List outEdges = new ArrayList();
    private boolean sorted = false;

    private void sortEdges() {
        if (!this.sorted) {
            Collections.sort(this.outEdges);
            this.sorted = true;
        }
    }

    public void add(DirectedEdge directedEdge) {
        this.outEdges.add(directedEdge);
        this.sorted = false;
    }

    public Coordinate getCoordinate() {
        Iterator iterator2 = this.iterator();
        if (!iterator2.hasNext()) {
            return null;
        }
        return ((DirectedEdge)iterator2.next()).getCoordinate();
    }

    public int getDegree() {
        return this.outEdges.size();
    }

    public List getEdges() {
        this.sortEdges();
        return this.outEdges;
    }

    public int getIndex(int n) {
        int n2;
        n = n2 = n % this.outEdges.size();
        if (n2 < 0) {
            n = n2 + this.outEdges.size();
        }
        return n;
    }

    public int getIndex(DirectedEdge directedEdge) {
        this.sortEdges();
        int n = 0;
        while (n < this.outEdges.size()) {
            if ((DirectedEdge)this.outEdges.get(n) == directedEdge) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getIndex(Edge edge) {
        this.sortEdges();
        int n = 0;
        while (n < this.outEdges.size()) {
            if (((DirectedEdge)this.outEdges.get(n)).getEdge() == edge) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public DirectedEdge getNextCWEdge(DirectedEdge directedEdge) {
        int n = this.getIndex(directedEdge);
        return (DirectedEdge)this.outEdges.get(this.getIndex(n - 1));
    }

    public DirectedEdge getNextEdge(DirectedEdge directedEdge) {
        int n = this.getIndex(directedEdge);
        return (DirectedEdge)this.outEdges.get(this.getIndex(n + 1));
    }

    public Iterator iterator() {
        this.sortEdges();
        return this.outEdges.iterator();
    }

    public void remove(DirectedEdge directedEdge) {
        this.outEdges.remove(directedEdge);
    }
}

