/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.planargraph;

import com.vividsolutions.jts.planargraph.Edge;
import com.vividsolutions.jts.planargraph.NodeMap;
import com.vividsolutions.jts.planargraph.PlanarGraph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Subgraph {
    protected List dirEdges;
    protected Set edges = new HashSet();
    protected NodeMap nodeMap;
    protected PlanarGraph parentGraph;

    public Subgraph(PlanarGraph planarGraph) {
        this.dirEdges = new ArrayList();
        this.nodeMap = new NodeMap();
        this.parentGraph = planarGraph;
    }

    public void add(Edge edge) {
        if (this.edges.contains(edge)) {
            return;
        }
        this.edges.add(edge);
        this.dirEdges.add(edge.getDirEdge(0));
        this.dirEdges.add(edge.getDirEdge(1));
        this.nodeMap.add(edge.getDirEdge(0).getFromNode());
        this.nodeMap.add(edge.getDirEdge(1).getFromNode());
    }

    public boolean contains(Edge edge) {
        return this.edges.contains(edge);
    }

    public Iterator dirEdgeIterator() {
        return this.dirEdges.iterator();
    }

    public Iterator edgeIterator() {
        return this.edges.iterator();
    }

    public PlanarGraph getParent() {
        return this.parentGraph;
    }

    public Iterator nodeIterator() {
        return this.nodeMap.iterator();
    }
}

