/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.planargraph.algorithm;

import com.vividsolutions.jts.planargraph.DirectedEdge;
import com.vividsolutions.jts.planargraph.Edge;
import com.vividsolutions.jts.planargraph.GraphComponent;
import com.vividsolutions.jts.planargraph.Node;
import com.vividsolutions.jts.planargraph.PlanarGraph;
import com.vividsolutions.jts.planargraph.Subgraph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class ConnectedSubgraphFinder {
    private PlanarGraph graph;

    public ConnectedSubgraphFinder(PlanarGraph planarGraph) {
        this.graph = planarGraph;
    }

    private void addEdges(Node object, Stack stack, Subgraph subgraph) {
        ((GraphComponent)object).setVisited(true);
        object = ((Node)object).getOutEdges().iterator();
        while (object.hasNext()) {
            GraphComponent graphComponent = (DirectedEdge)object.next();
            subgraph.add(((DirectedEdge)graphComponent).getEdge());
            if ((graphComponent = ((DirectedEdge)graphComponent).getToNode()).isVisited()) continue;
            stack.push(graphComponent);
        }
        return;
    }

    private void addReachable(Node node, Subgraph subgraph) {
        Stack<Node> stack = new Stack<Node>();
        stack.add(node);
        while (!stack.empty()) {
            this.addEdges((Node)stack.pop(), stack, subgraph);
        }
        return;
    }

    private Subgraph findSubgraph(Node node) {
        Subgraph subgraph = new Subgraph(this.graph);
        this.addReachable(node, subgraph);
        return subgraph;
    }

    public List getConnectedSubgraphs() {
        ArrayList<Subgraph> arrayList = new ArrayList<Subgraph>();
        GraphComponent.setVisited(this.graph.nodeIterator(), false);
        Iterator iterator2 = this.graph.edgeIterator();
        while (iterator2.hasNext()) {
            Node node = ((Edge)iterator2.next()).getDirEdge(0).getFromNode();
            if (node.isVisited()) continue;
            arrayList.add(this.findSubgraph(node));
        }
        return arrayList;
    }
}

